/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.AbstractHessianConnection;
import com.caucho.hessian.client.HessianConnectionException;
import com.caucho.hessian.client.HessianRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class HessianURLConnection
extends AbstractHessianConnection {
    private static final Logger log = Logger.getLogger(HessianURLConnection.class.getName());
    private URL _url;
    private URLConnection _conn;
    private int _statusCode;
    private String _statusMessage;
    private InputStream _inputStream;
    private InputStream _errorStream;

    HessianURLConnection(URL url, URLConnection conn) {
        this._url = url;
        this._conn = conn;
    }

    @Override
    public void addHeader(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    /*
     * Loose catch block
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        int retries = 1;
        while (true) {
            try {
                return this._conn.getOutputStream();
            }
            catch (ConnectException e) {
                if (retries < 3) {
                    ++retries;
                    log.warning("Connecting to '" + this._url + "' failed: " + e.getMessage() + ", retrying after 5 seconds...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new HessianRuntimeException("Error connecting '" + this._url + "'", e);
            }
            break;
        }
        catch (SocketTimeoutException e) {
            throw new HessianRuntimeException("Error connecting '" + this._url + "'", e);
        }
    }

    @Override
    public void sendRequest() throws IOException {
        if (this._conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)this._conn;
            this._statusCode = 500;
            try {
                this._statusCode = httpConn.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parseResponseHeaders(httpConn);
            InputStream is = null;
            if (this._statusCode != 200) {
                StringBuffer sb = new StringBuffer();
                try {
                    int ch;
                    is = httpConn.getInputStream();
                    if (is != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                        is.close();
                    }
                    if ((is = httpConn.getErrorStream()) != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                    }
                    this._statusMessage = sb.toString();
                }
                catch (FileNotFoundException e) {
                    throw new HessianConnectionException("HessianProxy cannot connect to '" + this._url, e);
                }
                catch (IOException e) {
                    if (is == null) {
                        throw new HessianConnectionException(String.valueOf(this._statusCode) + ": " + e, e);
                    }
                    throw new HessianConnectionException(String.valueOf(this._statusCode) + ": " + sb, e);
                }
                if (is != null) {
                    is.close();
                }
                throw new HessianConnectionException(String.valueOf(this._statusCode) + ": " + sb.toString());
            }
        }
    }

    protected void parseResponseHeaders(HttpURLConnection conn) throws IOException {
    }

    @Override
    public int getStatusCode() {
        return this._statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this._statusMessage;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._conn.getInputStream();
    }

    @Override
    public String getContentEncoding() {
        return this._conn.getContentEncoding();
    }

    @Override
    public void close() {
        this._inputStream = null;
    }

    @Override
    public void destroy() {
        this.close();
        URLConnection conn = this._conn;
        this._conn = null;
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }
}

