/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.pullrequest;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.github.GitHubRepository;
import com.pmease.quickbuild.plugin.scm.github.pullrequest.AbstractPullRequestsProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.PullRequestService;

@Editable(name="Specified Pull Requests", order=999)
@ScriptApi
public class SpecifiedPullRequestsProvider
extends AbstractPullRequestsProvider {
    private static final long serialVersionUID = 1L;
    private String pullIds;

    @Editable(name="Pull Request Ids", order=200, description="Sepcify the pull request ids you want to build, comma to separate each. For example, <code>12, 13, 18</code>")
    @Scriptable
    @ScriptApi
    public String getPullIds() {
        return this.pullIds;
    }

    public void setPullIds(String pullIds) {
        this.pullIds = pullIds;
    }

    @Override
    protected List<PullRequest> listPullRequests(GitHubRepository repo) {
        String str = this.getPullIds();
        Iterable it = Splitter.on((String)",").trimResults().split((CharSequence)str);
        PullRequestService service = this.getPullRequestService(repo);
        ArrayList list = Lists.newArrayList();
        for (String each : it) {
            try {
                list.add(service.getPullRequest((IRepositoryIdProvider)repo, Integer.valueOf(each).intValue()));
            }
            catch (NumberFormatException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return list;
    }
}

