/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.pullrequest;

import com.google.common.base.Throwables;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.scm.github.GitHubRepository;
import com.pmease.quickbuild.plugin.scm.github.pullrequest.AbstractPullRequestsProvider;
import java.io.IOException;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.PullRequestService;

@Editable(name="All Opened Pull Requests", order=100)
@ScriptApi
public class OpenedPullRequestsProvider
extends AbstractPullRequestsProvider {
    private static final long serialVersionUID = 1L;

    @Override
    protected List<PullRequest> listPullRequests(GitHubRepository repo) {
        PullRequestService service = this.getPullRequestService(repo);
        try {
            return service.getPullRequests((IRepositoryIdProvider)repo, "open");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

