/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.pullrequest;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.scm.github.GitHubRepository;
import com.pmease.quickbuild.plugin.scm.github.pullrequest.IPullRequestsProvider;
import com.pmease.quickbuild.plugin.scm.github.pullrequest.PullRequestBranchType;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.PullRequestService;

public abstract class AbstractPullRequestsProvider
implements IPullRequestsProvider {
    private static final long serialVersionUID = 1L;
    private PullRequestBranchType pullRequestBranchType = PullRequestBranchType.HEAD;

    protected abstract List<PullRequest> listPullRequests(GitHubRepository var1);

    @Override
    public Collection<ShortBranch> getPullRequests(GitHubRepository repo) {
        List<PullRequest> requests = this.listPullRequests(repo);
        ArrayList<ShortBranch> collection = new ArrayList<ShortBranch>();
        for (PullRequest each : requests) {
            ShortBranch headBranch = new ShortBranch();
            String path = "refs/pull/" + each.getNumber() + "/";
            headBranch.setName(path + "head");
            headBranch.setRevision(each.getHead().getSha());
            ShortBranch mergeBranch = new ShortBranch();
            mergeBranch.setName(path + "merge");
            mergeBranch.setRevision(UUID.randomUUID().toString());
            switch (this.getPullRequestBranchType()) {
                case HEAD: {
                    collection.add(headBranch);
                    break;
                }
                case MERGE: {
                    collection.add(mergeBranch);
                    break;
                }
                case BOTH: {
                    collection.add(headBranch);
                    collection.add(mergeBranch);
                }
            }
        }
        return collection;
    }

    protected PullRequestService getPullRequestService(GitHubRepository repo) {
        return new PullRequestService(repo.newGitHubClient());
    }

    @Override
    @Editable(name="Build Branch", order=100)
    @NotNull
    public PullRequestBranchType getPullRequestBranchType() {
        return this.pullRequestBranchType;
    }

    public void setPullRequestBranchType(PullRequestBranchType pullRequestbranchType) {
        this.pullRequestBranchType = pullRequestbranchType;
    }
}

