/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.issue;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.scm.github.GitHubPlugin;
import com.pmease.quickbuild.plugin.scm.github.issue.GitHubSetting;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GitHubTracker.class);

    public String getIssueUrlPattern() {
        GitHubSetting setting = GitHubSetting.get(Context.getConfiguration());
        return StringHelper.normalizeUrl((String)setting.getHost()) + "/" + setting.getRepository() + "/issues/$KEY";
    }

    public String extractIssueKey(String matched) {
        Long id = TrackerHelper.extractLong((String)matched);
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        return GitHubPlugin.class;
    }

    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        GitHubSetting setting = GitHubSetting.get(Context.getConfiguration());
        GitHubClient client = setting.newClient();
        LinkedHashMap issues = Maps.newLinkedHashMap();
        IssueService is = new IssueService(client);
        for (String each : keys) {
            try {
                org.eclipse.egit.github.core.Issue issue = is.getIssue((IRepositoryIdProvider)setting, Integer.valueOf(each).intValue());
                issues.put(each, this.convertIssue(issue));
            }
            catch (NumberFormatException e) {
                logger.error("fetch issue " + each + " failed.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("fetch issue " + each + " failed.", (Throwable)e);
            }
        }
        return issues;
    }

    private Issue convertIssue(org.eclipse.egit.github.core.Issue issue) {
        Issue result = new Issue();
        result.setIssueKey(String.valueOf(issue.getNumber()));
        if (issue.getAssignee() != null) {
            result.setAssignee(issue.getAssignee().getLogin());
        }
        result.setCreated(issue.getCreatedAt());
        result.setUpdated(issue.getUpdatedAt());
        if (issue.getUser() != null) {
            result.setReporter(issue.getUser().getLogin());
        }
        result.setSummary(issue.getTitle());
        result.setStatus(issue.getState());
        if (issue.getHtmlUrl().contains("/pull/")) {
            result.setIssueType("PR");
        } else {
            result.setIssueType("");
        }
        return result;
    }
}

