/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.issue;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.scm.github.GitHubPlugin;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import org.apache.wicket.request.Url;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="GitHub Server", order=1000, category={"Issue Tracker"})
public class GitHubSetting
extends AbstractTrackerSetting
implements IRepositoryIdProvider {
    private static final long serialVersionUID = 1L;
    private String repository;
    private String displayColumns;

    public GitHubSetting() {
        this.setIssuePattern("(?<!\\:)(?:#|bug:)\\d+");
    }

    public static GitHubSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (GitHubSetting)((Object)PluginSettingHelper.findConfigurationSetting(GitHubPlugin.class, (Configuration)configuration, (boolean)true));
    }

    public GitHubClient newClient() {
        String host = this.getHost();
        Url url = Url.parse((String)host);
        String h = "github.com".equalsIgnoreCase(url.getHost()) || "gist.github.com".equalsIgnoreCase(url.getHost()) ? "api.github.com" : url.getHost();
        GitHubClient client = new GitHubClient(h, url.getPort().intValue(), url.getProtocol());
        client.setCredentials(this.getUser(), this.getPassword());
        return client;
    }

    public static boolean isApplicable(Configuration c) {
        return GitHubSetting.get(c) != null;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Editable(name="Issue Pattern", order=1100, description="Specify <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> of GitHub issue keys in SCM commit message. This pattern will be used by QuickBuild to transform issue keys to issue links. The default pattern will recognize <i>#123</i> and <i>bug:123</i> as issue keys while won't recognize <i>:#123</i>.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getIssuePattern() {
        return super.getIssuePattern();
    }

    @Editable(name="Repository", order=1200, description="Specify the repository you want to retrieve issues from, the repository should in {user}/{repository} format, for example: quickbuild/quickbuild")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Returns the repository")
    public String getRepository() {
        return this.repository;
    }

    @Editable(name="Columns on Issue tab", order=1300, description="Specify which columns you want to display on issue tab. Leave empty to use default. Comma to separate columns, for example, <code>Key, Summary, Type, Assignee</code>Valid columns including: Key, Summary, Type, Status, Assignee, Reporter, Created, Updated, Modifications.")
    public String getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(String displayColumns) {
        this.displayColumns = displayColumns;
    }

    public String generateId() {
        String repo = this.getRepository();
        if (repo.endsWith(".git")) {
            repo = repo.substring(0, repo.length() - ".git".length());
        }
        return repo;
    }
}

