/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.issue;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.scm.github.issue.GitHubSetting;
import com.pmease.quickbuild.plugin.scm.github.issue.LinkIssueToolbar;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueReportPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.model.IModel;

public class GitHubIssueReportPanel
extends IssueReportPanel {
    private static final long serialVersionUID = 1L;

    public GitHubIssueReportPanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected boolean isConnectionFailed() {
        return false;
    }

    protected void addToolbars(DataGrid dataGrid) {
        dataGrid.addTopToolbar((AbstractToolbar)new LinkIssueToolbar(dataGrid, ""));
        super.addToolbars(dataGrid);
    }

    protected Collection<TableColumn> getTableColumns() {
        ArrayList list = Lists.newArrayList();
        GitHubSetting setting = GitHubSetting.get(Context.getConfiguration());
        String str = setting.getDisplayColumns();
        if (Strings.isNullOrEmpty((String)str)) {
            str = "Key, Summary, Type, Status, Assignee, Reporter, Modifications";
        }
        ArrayList names = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)str));
        ArrayList columns = Lists.newArrayList((Iterable)this.getRenderer().getColumns());
        for (String each : names) {
            TableColumn t = GitHubIssueReportPanel.findColumn(each, columns);
            if (t != null) {
                list.add(t);
                continue;
            }
            Context.getLogger().warn("Column " + each + " not found");
        }
        return list;
    }

    private static TableColumn findColumn(String name, List<TableColumn> columns) {
        for (TableColumn c : columns) {
            if (c.getTitle().equalsIgnoreCase(name)) {
                return c;
            }
            if (!c.getKey().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }
}

