/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.issue;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.github.issue.GitHubSetting;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.service.UserService;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create GitHub Issue", category={"Issue Tracker"}, description="This step creates a bug/issue in defined GitHub server")
public class CreateIssueStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String milestone;
    private String labels;
    private String title;
    private String body;
    private String assignee;

    public void run() {
        try {
            this.onBeforeRun();
            Issue issue = this.createIssue();
            this.getIssueActions().put(String.valueOf(issue.getNumber()), "create");
            this.onAfterRun();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Issue createIssue() throws IOException {
        GitHubSetting setting = GitHubSetting.get(Context.getConfiguration());
        GitHubClient client = setting.newClient();
        Issue issue = new Issue();
        issue.setTitle(this.getTitle());
        issue.setBody(this.getBody());
        ArrayList labels = Lists.newArrayList();
        LinkedHashSet labelStr = Sets.newLinkedHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)this.getLabels()));
        for (String each : labelStr) {
            Label label = new Label();
            label.setName(each);
            labels.add(label);
        }
        issue.setLabels((List)labels);
        if (!Strings.isNullOrEmpty((String)this.getAssignee())) {
            UserService us = new UserService(client);
            User user = us.getUser(this.getAssignee());
            issue.setAssignee(user);
        }
        if (!Strings.isNullOrEmpty((String)this.getMilestone())) {
            MilestoneService ms = new MilestoneService(client);
            String str = this.getMilestone();
            Milestone milestone = null;
            for (Milestone each : ms.getMilestones((IRepositoryIdProvider)setting, "open")) {
                if (!each.getTitle().equalsIgnoreCase(str)) continue;
                milestone = each;
                break;
            }
            if (milestone == null) {
                throw new QuickbuildException("Either milestone " + str + " does not exist or this milestone was closed.");
            }
            issue.setMilestone(milestone);
        }
        IssueService is = new IssueService(client);
        return is.createIssue((IRepositoryIdProvider)setting, issue);
    }

    @Editable(name="Issue Title", order=1000)
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Editable(name="Issue Comment", order=1100, description="Specify the issue comment")
    @Scriptable
    @ScriptApi
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Editable(name="Issue Labels", order=1200, description="Specify the labels this issue contains. Comma to separate each label.")
    @Scriptable
    @ScriptApi
    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    @Editable(name="Issue Milestone", order=1300, description="Specify the milestone title which this issue belongs to.")
    @Scriptable
    @ScriptApi(value="Get issue milestone")
    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    @Editable(name="Assignee", order=1400, description="Specify the assignee name. Here, the assignee name is the login name of this user.")
    @Scriptable
    @ScriptApi
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getExtraAttributes() {
        throw new UnsupportedOperationException();
    }
}

