/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.scm.github.GitHubPlugin;
import com.pmease.quickbuild.plugin.scm.github.gadget.GitHubIssueGadgetRenderer;
import com.pmease.quickbuild.plugin.scm.github.issue.GitHubSetting;
import com.pmease.quickbuild.plugin.tracker.core.gadget.AbstractIssueGadget;
import java.util.List;

@Editable(name="GitHub Issues", category={"Changes and Issues"})
public class GitHubIssueGadget
extends AbstractIssueGadget {
    private static final long serialVersionUID = 1L;
    private int displayedBuilds = 1;

    protected void checkPermission() {
        super.checkPermission();
        if (GitHubSetting.get(Context.getConfiguration()) == null) {
            throw new QuickbuildException("No GitHub issue setting defined for the configuration: " + Context.getConfiguration().getPathName());
        }
    }

    private static List<String> getAvailableColumns() {
        return Lists.newArrayList((Object[])new String[]{"Key", "Summary", "Type", "Status", "Assignee", "Reporter", "Modifications"});
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(GitHubPlugin.class);
    }

    protected TableRenderer createGadgetRenderer() {
        return new GitHubIssueGadgetRenderer(this.getCategory(), this);
    }

    @Editable(name="Builds Displayed", description="How many builds to be displayed. By default, only the build selected will be displayed")
    public int getDisplayedBuilds() {
        return this.displayedBuilds;
    }

    public void setDisplayedBuilds(int displayedBuilds) {
        this.displayedBuilds = displayedBuilds;
    }
}

