/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.github;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.github.pullrequest.IPullRequestsProvider;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.request.Url;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;

@Editable(name="GitHub", description="Configure a GitHub repository here.")
@ScriptApi
public class GitHubRepository
extends GitRepository
implements IRepositoryIdProvider {
    private String apiHost;
    private static final Pattern PULL_REQUEST_BRANCH = Pattern.compile("/?refs/pull/(\\d+)/(.*)");
    private IPullRequestsProvider pullsProvider;
    private String pullRequestComment;

    protected void checkoutByRevision(GitRevision revision) {
        this.onBuildStart();
        super.checkoutByRevision(revision);
    }

    private void onBuildStart() {
        if (this.getPullsProvider() == null) {
            return;
        }
        try {
            this.updateCommitStatus("Build " + Context.getBuild().getVersion() + " is started", "pending");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void buildFinished() {
        if (this.getPullsProvider() == null) {
            return;
        }
        try {
            String state;
            Build build = Context.getBuild();
            switch (build.getStatus()) {
                case FAILED: {
                    state = "error";
                    break;
                }
                case CANCELLED: 
                case TIMEOUT: {
                    state = "failure";
                    break;
                }
                default: {
                    state = "success";
                }
            }
            this.updateCommitStatus(String.format("Build %s finished with status %s", build.getVersion(), build.getStatus().name()), state);
            String str = this.getPullRequestComment();
            if (!Strings.isNullOrEmpty((String)str)) {
                IssueService is = new IssueService(this.newGitHubClient());
                is.createComment((IRepositoryIdProvider)this, this.getPullRequestId(), str);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @ScriptApi(value="Returns all opened pull requests")
    public List<PullRequest> getOpenedPullRequests() {
        return this.getPullRequests("open");
    }

    @ScriptApi(value="Returns all closed pull requests")
    public List<PullRequest> getClosedPullRequests() {
        return this.getPullRequests("closed");
    }

    private List<PullRequest> getPullRequests(String state) {
        GitHubClient client = this.newGitHubClient();
        PullRequestService ps = new PullRequestService(client);
        try {
            return ps.getPullRequests((IRepositoryIdProvider)this, state);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public GitHubClient newGitHubClient() {
        String fetchUrl = this.getFetchUrl();
        Preconditions.checkArgument((fetchUrl.startsWith("http") || fetchUrl.startsWith("https") ? 1 : 0) != 0, (Object)"Fetch url should be start with protocol http or https");
        Url url = Url.parse((String)fetchUrl);
        String host = "github.com".equalsIgnoreCase(url.getHost()) || "gist.github.com".equalsIgnoreCase(url.getHost()) ? "api.github.com" : url.getHost();
        GitHubClient client = new GitHubClient(host, url.getPort().intValue(), url.getProtocol());
        client.setCredentials(this.getUserName(), this.getPassword());
        client.setUserAgent("QuickBuildAgent/5.1.0");
        return client;
    }

    private void updateCommitStatus(String message, String state) throws IOException {
        GitHubClient client = this.newGitHubClient();
        String sha = ((GitRevision)this.getRevision()).getValue();
        CommitService cs = new CommitService(client);
        CommitStatus status = new CommitStatus();
        status.setState(state);
        status.setTargetUrl(Quickbuild.getInstance().getUrl() + "/build/" + Context.getBuild().getId());
        status.setDescription(message);
        status.setState(state);
        cs.createStatus((IRepositoryIdProvider)this, sha, status);
    }

    private int getPullRequestId() {
        String branch = this.getActualBranch();
        Matcher matcher = PULL_REQUEST_BRANCH.matcher(branch);
        if (!matcher.matches()) {
            Context.getLogger().debug("Branch " + branch + " for repo " + (Object)((Object)this) + " does not look like pull request");
            throw new IllegalArgumentException();
        }
        String pullRequestId = matcher.group(1);
        if (pullRequestId == null) {
            Context.getLogger().debug("Branch " + branch + " for repo " + (Object)((Object)this) + " does not contain pull request id");
            throw new IllegalArgumentException();
        }
        return Integer.valueOf(pullRequestId);
    }

    public Collection<ShortBranch> getShortBranches() {
        if (this.getPullsProvider() != null) {
            return this.getPullsProvider().getPullRequests(this);
        }
        return super.getShortBranches();
    }

    public String getActualBranch() {
        if (this.getPullsProvider() == null) {
            return super.getActualBranch();
        }
        if (this.getBuild().getRequest().getShortBranch() != null) {
            return this.getBuild().getRequest().getShortBranch().getName();
        }
        throw new QuickbuildException("Unable to determine short branch to build against.");
    }

    public String generateId() {
        String fetchUrl = this.getFetchUrl();
        Iterable it = Splitter.on((String)"/").trimResults().split((CharSequence)fetchUrl);
        ArrayList list = Lists.newArrayList((Iterable)it);
        Preconditions.checkArgument((list.size() > 2 ? 1 : 0) != 0);
        String username = (String)list.get(list.size() - 2);
        String repoName = (String)list.get(list.size() - 1);
        if (repoName.endsWith(".git")) {
            repoName = repoName.substring(0, repoName.length() - ".git".length());
        }
        return username + "/" + repoName;
    }

    @Editable(order=1700, name="Branch Name", description="Optionally specify the branch which you want to pull. If not specified, the 'master' branch will be used. Specifically, if the name contains wildcards, QB will build all branches matching the pattern upon branch update.")
    @ScriptApi(value="Get specified branch to build against.")
    @Scriptable
    public String getBranch() {
        return super.getBranch();
    }

    @Editable(name="Pull Requests", order=1750, description="Optionally specify pull requests to build against. Please note that if this is specified, branch property specified above will be ignored.")
    @ScriptApi(value="Returns pull request provider")
    public IPullRequestsProvider getPullsProvider() {
        return this.pullsProvider;
    }

    public void setPullsProvider(IPullRequestsProvider pullsProvider) {
        this.pullsProvider = pullsProvider;
    }

    @Editable(order=1800, name="Commit or Tag to Build", description="Optionally specify the commit or tag on the branch or pull request to build against. If not specified, tip commit of specified branch or pull request will be checked out.")
    @ScriptApi(value="Get specified commit or tag to build against. Null to build against tip commit.")
    @Scriptable
    public String getBuildRevision() {
        return super.getBuildRevision();
    }

    @ScriptApi(value="Returns the host for providing service of GitHub API")
    public String getApiServer() {
        String host = this.getApiHost();
        return Strings.isNullOrEmpty((String)host) ? "https://api.github.com" : host;
    }

    @Editable(name="GitHub API Server", order=2000, description="Specify GitHub API server, by default, it is https://api.github.com")
    @Scriptable
    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    @Editable(name="Comment for Pull Request", order=2200, description="Specify the comment you want to add to the pull request after build finished, leave empty if you don't want to add any comment")
    @Scriptable
    @ScriptApi(value="Returns the comment which will be added to the pull request")
    public String getPullRequestComment() {
        return this.pullRequestComment;
    }

    public void setPullRequestComment(String comment) {
        this.pullRequestComment = comment;
    }
}

