/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.busted.renderer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.junit.JUnitHelper;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.ArrayList;
import java.util.List;

public class ViewTestSourceLinkItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public ViewTestSourceLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        String color = each.getColor();
                        String message = 1.escapeMessage((String)each.getMessage());
                        while (i <= each.getEndLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">");
                            if (i == each.getStartLine()) {
                                sb.append(ReportUtils.firstOf((String)message, (int)4));
                            } else {
                                sb.append("&nbsp;&nbsp;&nbsp;");
                            }
                            sb.append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        ArrayList blocks = Lists.newArrayList();
        for (DataRow each : rows) {
            Block block = new Block();
            int line = Math.max(0, each.getInt("line"));
            block.setStartLine(line);
            block.setEndLine(line);
            JUnitHelper.Status status = JUnitHelper.Status.valueOf((String)each.getString("status"));
            block.setMessage(status.name());
            block.setColor(ViewTestSourceLinkItem.getBlockColor(status));
            blocks.add(block);
        }
        return (Block[])Iterables.toArray((Iterable)blocks, Block.class);
    }

    static String getBlockColor(JUnitHelper.Status status) {
        switch (status) {
            case PASS: {
                return "#008C00";
            }
            case ERROR: {
                return "#FF1A00";
            }
            case FAILURE: {
                return "#FF7400";
            }
        }
        return "#666666";
    }
}

