/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.busted.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.busted.renderer.TestDetailsColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public TestDetailsColumnPanel(String id, IModel<ItemContext> model, TestDetailsColumn column) {
        super(id, model);
        DataRow row = this.getRow();
        int runs = (Integer)row.getValue("totalRuns");
        WebMarkupContainer runsContainer = new WebMarkupContainer("runsContainer");
        this.add(new Component[]{runsContainer});
        if (runs > 1) {
            runsContainer.add(new Component[]{new Label("totalRuns", String.valueOf(runs))});
            runsContainer.add(new Component[]{new Label("passedRuns", row.getValueAsString("passedRuns"))});
            runsContainer.add(new Component[]{new Label("failedRuns", row.getValueAsString("failedRuns"))});
        } else {
            runsContainer.setVisible(false);
        }
        String status = row.getValueAsString("status");
        status = ReportUtils.firstOf((String)status, (int)4);
        Label label = new Label("status", status);
        label.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{label});
        this.add(new Component[]{new Label("testName", row.getValueAsString("testName"))});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        this.add(new Component[]{new Label("committers", row.getValueAsString("committers"))});
        String hostName = row.getValueAsString("hostName");
        this.add(new Component[]{new Label("hostname", hostName).setVisibilityAllowed(!Strings.isNullOrEmpty((String)hostName))});
        this.add(new Component[]{new Label("suiteName", row.getValueAsString("suiteName"))});
        this.add(new Component[]{new Label("source", row.getValueAsString("source"))});
        this.add(new Component[]{new Label("line", String.valueOf(row.getInt("line")))});
        this.add(new Component[]{column.getSourceLinkItem().createComponent("viewsourcelink", model)});
        this.add(new Component[]{new WebMarkupContainer("toTop").setVisible(!column.getRenderer().isInDropDown())});
        this.add(new Component[]{this.createLabel(row, "errorType")});
        this.add(new Component[]{this.createLabel(row, "errorMessage")});
        this.add(new Component[]{this.createLabel(row, "failureType")});
        this.add(new Component[]{this.createLabel(row, "failureMessage")});
    }

    private Component createLabel(DataRow row, String id) {
        String value = row.getValueAsString(id);
        return new Label(id, this.formatMessage(value)).setEscapeModelStrings(false).setVisible(!StringUtils.isEmpty((String)value));
    }

    private String formatMessage(String original) {
        if (StringUtils.isEmpty((String)original)) {
            return "";
        }
        Pattern p = Pattern.compile("___QB__LINE__SEP___");
        Matcher m = p.matcher(original);
        ArrayList<String> messages = new ArrayList<String>();
        int previous = 0;
        while (m.find()) {
            int start = m.start();
            messages.add(original.substring(previous, start));
            previous = m.end();
        }
        if (previous < original.length()) {
            messages.add(original.substring(previous));
        }
        if (messages.size() > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<ol>");
            for (int i = 0; i < messages.size() && i <= 5; ++i) {
                String s = StringEscapeUtils.escapeHtml((String)((String)messages.get(i)));
                sb.append("<li><pre>").append(s).append("</pre></li>");
            }
            sb.append("</ol>");
            if (messages.size() > 5) {
                sb.append("<p>...</p>");
            }
            return sb.toString();
        }
        return "<pre>" + StringEscapeUtils.escapeHtml((String)original) + "</pre>";
    }

    private DataRow getRow() {
        ItemContext context = (ItemContext)this.getDefaultModelObject();
        return context.getDataRow();
    }
}

