/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.busted.generator;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.reader.XMLResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.junit.JUnitHelper;
import com.pmease.quickbuild.plugin.report.junit.generator.JUnitXMLResourceReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;

public class TestCaseProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public TestCaseProcessor(ReportCategory category) {
        super(category);
    }

    protected XMLResourceReader createDefaultReader() {
        return new JUnitXMLResourceReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(GeneratorResource resource) {
        ResourceReader reader = this.createReader();
        if (reader == null) {
            return;
        }
        GeneratorContext context = this.getContext();
        context.setResource((Object)resource);
        try {
            DataRow row;
            Document doc;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Start opening original document");
            }
            if ((doc = (Document)reader.read()) == null) {
                return;
            }
            List nodes = doc.selectNodes("//testcase");
            DataReport report = this.getContext().getDestReport();
            for (Element each : nodes) {
                row = report.addRow();
                this.processElement(each, row, TestCaseProcessor.isSkippedTest(each));
            }
            nodes = doc.selectNodes("//testsuite/error");
            for (Element each : nodes) {
                row = report.addRow();
                this.processErrorTestsuite(row, each, JUnitHelper.Status.ERROR);
            }
            nodes = doc.selectNodes("//testsuite/failure");
            for (Element each : nodes) {
                row = report.addRow();
                this.processErrorTestsuite(row, each, JUnitHelper.Status.FAILURE);
            }
            nodes = doc.selectNodes("//ignored-testcase");
            for (Element each : nodes) {
                row = report.addRow();
                this.processElement(each, row, true);
            }
        }
        finally {
            reader.close();
        }
    }

    static boolean isSkippedTest(Element e) {
        if (e.element("skipped") != null) {
            return true;
        }
        String status = e.attributeValue("status");
        return !Strings.isNullOrEmpty((String)status) && "notrun".equalsIgnoreCase(status);
    }

    private Element getSuiteElement(Element testcaseElement) {
        Element parent = testcaseElement.getParent();
        do {
            if (!Objects.equal((Object)"testsuite", (Object)parent.getName())) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    private void processElement(Element each, DataRow row, boolean isSkipped) {
        Element parent = this.getSuiteElement(each);
        if (parent == null) {
            throw new QuickbuildException("Malformed document");
        }
        row.setValue("suiteName", (Object)parent.attributeValue("name"));
        String hostName = parent.attributeValue("hostname");
        if (hostName == null) {
            hostName = "";
        }
        row.setValue("hostName", (Object)hostName);
        row.setValue("testName", (Object)each.attributeValue("name"));
        row.setValue("duration", DataTypes.DURATION.fromString(each.valueOf("./@time * 1000"), null, Locale.US));
        String source = each.attributeValue("classname");
        int pos = source.lastIndexOf(58);
        if (pos > 0) {
            String path = source.substring(0, pos);
            int line = (Integer)DataTypes.INTEGER.fromString(source.substring(pos + 1));
            row.setValue("source", (Object)path);
            row.setValue("line", (Object)line);
        } else {
            row.setValue("source", (Object)source);
            row.setValue("line", (Object)0);
        }
        row.setValue("source", (Object)this.resolveSourcePath(row.getValueAsString("source")));
        String errorMessage = each.valueOf("./error");
        row.setValue("errorMessage", (Object)errorMessage);
        String errorType = each.valueOf("./error/@type");
        row.setValue("errorType", (Object)errorType);
        String failureMessage = each.valueOf("./failure");
        row.setValue("failureMessage", (Object)failureMessage);
        String failureType = each.valueOf("./failure/@type");
        row.setValue("failureType", (Object)failureType);
        JUnitHelper.Status status = isSkipped ? JUnitHelper.Status.SKIP : (!Strings.isNullOrEmpty((String)errorType) || !Strings.isNullOrEmpty((String)errorMessage) ? JUnitHelper.Status.ERROR : (!Strings.isNullOrEmpty((String)failureType) || !Strings.isNullOrEmpty((String)failureMessage) ? JUnitHelper.Status.FAILURE : JUnitHelper.Status.PASS));
        row.setValue("status", (Object)status.name());
        row.setValue("totalRuns", (Object)1);
        switch (status) {
            case PASS: {
                row.setValue("passedRuns", (Object)1);
                break;
            }
            case ERROR: 
            case FAILURE: {
                row.setValue("failedRuns", (Object)1);
                break;
            }
            case SKIP: {
                row.setValue("skippedRuns", (Object)1);
            }
        }
        row.setValue("hasSysout", (Object)Boolean.valueOf(each.valueOf("boolean(string(../system-out) != '' or string(../system-err) != '')")));
    }

    private String resolveSourcePath(String path) {
        File workspaceDir = Context.getConfiguration().getWorkspaceDir();
        File file = new File(workspaceDir, path);
        if (file.exists()) {
            try {
                return ReportUtils.getRelativePath((String)file.getCanonicalPath(), (String)workspaceDir.getCanonicalPath());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return path;
    }

    private void processErrorTestsuite(DataRow row, Element errorElement, JUnitHelper.Status status) {
        Element parent = this.getSuiteElement(errorElement);
        row.setValue("suiteName", (Object)parent.attributeValue("name"));
        String hostName = parent.attributeValue("hostname");
        if (hostName == null) {
            hostName = "";
        }
        row.setValue("hostName", (Object)hostName);
        row.setValue("testName", (Object)"<no name>");
        row.setValue("duration", (Object)0L);
        row.setValue("source", (Object)"unknown");
        row.setValue("line", (Object)0);
        if (status == JUnitHelper.Status.ERROR) {
            row.setValue("errorType", (Object)errorElement.attributeValue("type"));
            row.setValue("errorMessage", (Object)errorElement.getText());
        } else {
            row.setValue("failureType", (Object)errorElement.attributeValue("type"));
            row.setValue("failureMessage", (Object)errorElement.getText());
        }
        row.setValue("status", (Object)status.name());
        row.setValue("totalRuns", (Object)1);
        row.setValue("failedRuns", (Object)1);
        row.setValue("hasSysout", (Object)Boolean.valueOf(errorElement.valueOf("boolean(string(../system-out) != '' or string(../system-err) != '')")));
    }
}

