/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.plugin.scm.clearcase.NodeAndDirBasedViewName;
import com.pmease.quickbuild.plugin.scm.clearcase.View;
import com.pmease.quickbuild.plugin.scm.clearcase.ViewNameProvider;
import com.pmease.quickbuild.plugin.scm.clearcase.ViewProvider;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import javax.validation.constraints.NotNull;

public abstract class NewSnapshotViewProvider
implements ViewProvider {
    private static final long serialVersionUID = 1L;
    private ViewNameProvider viewNameProvider = new NodeAndDirBasedViewName(this);
    private String rootPath;
    private String mkviewOpts;
    protected ClearCaseRepository repository;
    private ProofBuildSupport proofBuildSupport;
    private transient View view;

    public NewSnapshotViewProvider(ClearCaseRepository repository) {
        this.repository = repository;
    }

    @Editable(name="View Name", order=50, description="Specify name of the snapshot view which will be created by QuickBuild to check out code for the build.")
    @NotNull
    @ScriptApi(value="Get view name provider.")
    public ViewNameProvider getViewNameProvider() {
        return this.viewNameProvider;
    }

    public void setViewNameProvider(ViewNameProvider viewNameProvider) {
        this.viewNameProvider = viewNameProvider;
    }

    @ScriptApi(value="Get name of the view to be used for checkout.")
    public String getViewName() {
        return this.getViewNameProvider().getViewName();
    }

    @Editable(order=80, name="View Root Directory", description="Specify where to place source code of the created snapshot view. A non-absolute path is considered to be relative to the configuration workspace directory. And if this property is left empty, the workspace directory itself is assumed.")
    @Scriptable
    @ScriptApi(value="Get view root path. Null will be returned if workspace directory is used.")
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @ScriptApi(value="Get view root directory.")
    public File getRootDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getRootPath());
    }

    @Editable(order=90, name="View Create Options", description="Optionally specify extra options for the cleartool mkview sub command to create snapshot view for purpose of build. Options that can be specified here are restricted to <b>-tmode, -ptime, -stgloc, -vws, -cachesize</b>, and you should NOT specify options of <b>-snapshot</b> and <b>-tag</b> here since they will be added by QuickBuild automatically.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get additional mkview options. Null if not specified.")
    public String getMkviewOpts() {
        return this.mkviewOpts;
    }

    public void setMkviewOpts(String mkviewOpts) {
        this.mkviewOpts = mkviewOpts;
    }

    @Override
    @Editable(order=500, description="Check this to enable proof build for this view.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled.")
    public ProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(ProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @ScriptApi(value="Get the repository object.")
    public ClearCaseRepository getRepository() {
        return this.repository;
    }

    @ScriptApi(value="Whether or not this is a dynamic view.")
    public boolean isDynamic() {
        return false;
    }

    protected abstract String getCfgSpec();

    protected abstract String getStreamSelector();

    @Override
    public final View getView() {
        if (this.view == null) {
            final File rootDir = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getRootPath());
            final String name = this.getViewName();
            final boolean[] viewExists = new boolean[]{true};
            Commandline cmdline = this.repository.buildCleartoolCmd("lsview").addArgValue("-s").addArgValue(name);
            Commandline.ExecuteResult result = cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                public void consume(String line) {
                    if (line.contains("No matching entries found for view tag")) {
                        Context.getLogger().warn(line);
                        viewExists[0] = false;
                    } else {
                        Context.getLogger().error(line);
                    }
                }
            });
            if (viewExists[0]) {
                result.checkReturnCode();
            } else {
                this.repository.createView(name, this.getStreamSelector(), this.getMkviewOpts(), rootDir);
            }
            this.view = new View(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getCfgSpec() {
                    return NewSnapshotViewProvider.this.getCfgSpec();
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public File getRootDir() {
                    return rootDir;
                }

                @Override
                public String getSubPaths() {
                    return StringUtils.join(NewSnapshotViewProvider.this.repository.getLoadPaths(this.getCfgSpec()), (String)"\n");
                }

                @Override
                public boolean isDynamic() {
                    return false;
                }
            };
        }
        return this.view;
    }

    public static class ProofBuildSupport
    extends ClearCaseProofBuildSupport {
        private static final long serialVersionUID = 1L;
        private NewSnapshotViewProvider viewProvider;

        public ProofBuildSupport(NewSnapshotViewProvider viewProvider) {
            this.viewProvider = viewProvider;
        }

        @Override
        public ClearCaseRepository getRepository() {
            return this.viewProvider.getRepository();
        }
    }
}

