/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.plugin.scm.clearcase.NewSnapshotViewProvider;
import com.pmease.quickbuild.util.StringUtils;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=200, name="Create View as Necessary Using Stream Info")
@ScriptApi(value="Create new snapshot view as necessary using UCM stream information.")
public class NewSnapshotViewFromStreamProvider
extends NewSnapshotViewProvider {
    private static final long serialVersionUID = 1L;
    private static Pattern labelPattern = Pattern.compile("^\\s*BaselineLbtype\\s*->\\s*lbtype:(.*)@.*");
    private String streamSelector;
    private String loadRules;
    private String baselineSelectors;

    public NewSnapshotViewFromStreamProvider(ClearCaseRepository repository) {
        super(repository);
    }

    @Override
    @Editable(order=100, description="Specify stream selector, for example <b>project1_Integration@\\pvob1</b>. QuickBuild will derive config spec based on configuration of this stream, the load rules, and baselines (see below). The derived config spec will be used to configure the build snapshot view specified above. The build snapshot view will then be updated to run the build.")
    @NotEmpty
    @ScriptApi(value="Get stream selector to build against.")
    @Scriptable
    public String getStreamSelector() {
        return this.streamSelector;
    }

    public void setStreamSelector(String streamSelector) {
        this.streamSelector = streamSelector;
    }

    @Editable(order=200, description="Specify load rules of the build snapshot view with one load rule per line. For example:<br><b>load \\myvob1\\dir1<br>load \\myvob2<br></b>If not specified, QuickBuild will load root directories of all VOB compoents attached to specified baselines (or foundation baselines if <b>baselines</b> property is not specified).")
    @Multiline(value=6)
    @Scriptable
    @ScriptApi(value="Get load rules. Null if not specified.")
    public String getLoadRules() {
        return this.loadRules;
    }

    public void setLoadRules(String loadRules) {
        this.loadRules = loadRules;
    }

    @Editable(order=300, description="Optionally specify baseline selectors to build against, for example: <b>REL1@\\pvob1</b>. Multiple selectors should be separated by comma character, and all baselines specified here should have corresponding labels. If specified, the build snapshot view will be configured to build against exactly the same set of source code marked by these baselines; otherwise, latest code of the stream will be used to run the build.")
    @Expressions(value={"latest baselines", "${current.latestBaselines}", "recommended baselines", "${current.recommendedBaselines}", "foundation baselines", "${current.foundationBaselines}"})
    @Scriptable
    @ScriptApi(value="Get baseline selectors. Null if build against latest code.")
    public String getBaselineSelectors() {
        return this.baselineSelectors;
    }

    public void setBaselineSelectors(String baselineSelectors) {
        this.baselineSelectors = baselineSelectors;
    }

    @ScriptApi(value="Get all latest baselines of this stream.")
    public String getLatestBaselines() {
        return this.getStreamBaselines("latest_bls");
    }

    @ScriptApi(value="Get all recommended baselines of this stream.")
    public String getRecommendedBaselines() {
        return this.getStreamBaselines("rec_bls");
    }

    @ScriptApi(value="Get all foundation baselines of this stream.")
    public String getFoundationBaselines() {
        return this.getStreamBaselines("found_bls");
    }

    @ScriptApi(value="Get name of the stream without vob suffix.")
    public String getStream() {
        return StringUtils.substringBefore((String)this.getStreamSelector(), (String)"@");
    }

    private Map<String, String> resolveBaselines(String[] baselineSelectors) {
        Context.getLogger().info("Resolving baseline dependency and overriden...");
        HashMap<String, String> resolvedBaselines = new HashMap<String, String>();
        Stack<String> stack = new Stack<String>();
        for (String baselineSelector : baselineSelectors) {
            stack.push(baselineSelector);
        }
        while (!stack.empty()) {
            String baselineSelector = (String)stack.pop();
            String component = this.getBaselineComponent(baselineSelector);
            if (resolvedBaselines.get(component) != null) continue;
            resolvedBaselines.put(component, baselineSelector);
            for (String dependent : this.getBaselineDependents(baselineSelector)) {
                stack.push(dependent);
            }
        }
        return resolvedBaselines;
    }

    private String getBaselineComponent(String baselineSelector) {
        final String[] component = new String[]{null};
        Commandline cmdline = this.repository.buildCleartoolCmd("lsbl").addArgLine("-fmt %[component]Xp").addArgValue(baselineSelector);
        cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                String[] fields = line.split("\\s");
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.trim().equals("")) continue;
                    component[0] = StringUtils.substring((String)field.trim(), (int)"component:".length());
                    break;
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (StringUtils.isBlank((String)component[0])) {
            throw new QuickbuildException("Failed to find associated component for baseline '" + baselineSelector + "'.");
        }
        return component[0];
    }

    private List<String> getBaselineDependents(String baselineSelector) {
        final LinkedList<String> dependents = new LinkedList<String>();
        Commandline cmdline = this.repository.buildCleartoolCmd("lsbl").addArgLine("-fmt %[depends_on]Xp").addArgValue(baselineSelector);
        cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                String[] fields = line.split("\\s");
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.trim().length() == 0) continue;
                    dependents.add(StringUtils.strip((String)field.trim(), (String)"\""));
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return dependents;
    }

    private String getComponentRootDir(String component) {
        final String[] rootDir = new String[]{null};
        Commandline cmdline = this.repository.buildCleartoolCmd("lscomp").addArgLine("-fmt %[root_dir]p").addArgValue(component);
        cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                rootDir[0] = line.trim();
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        if (rootDir[0] != null && rootDir[0].trim().length() == 0) {
            rootDir[0] = null;
        }
        if (rootDir[0] != null) {
            rootDir[0] = StringUtils.strip((String)rootDir[0], (String)"\"");
        }
        return rootDir[0];
    }

    private String getBaselineLabel(String baseline) {
        final String[] label = new String[]{null};
        Commandline cmdline = this.repository.buildCleartoolCmd("describe").addArgValue("baseline:" + baseline);
        cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                Matcher matcher = labelPattern.matcher(line);
                if (matcher.find()) {
                    label[0] = matcher.group(1).trim();
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (label[0] != null && label[0].trim().length() == 0) {
            label[0] = null;
        }
        return label[0];
    }

    private String getStreamBaselines(String baselineType) {
        final LinkedList baselineSelectors = new LinkedList();
        Commandline cmdline = this.repository.buildCleartoolCmd("lsstream").addArgLine("-fmt %[" + baselineType + "]Xp").addArgValue(this.getStreamSelector());
        cmdline.execute(this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                String[] fields = line.split("\\s");
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.trim().length() == 0) continue;
                    baselineSelectors.add(StringUtils.substring((String)field.trim(), (int)"baseline:".length()));
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return StringUtils.join(baselineSelectors, (char)',');
    }

    @Override
    @ScriptApi(value="Get the repository object.")
    public ClearCaseRepository getRepository() {
        return this.repository;
    }

    @Override
    @ScriptApi(value="Whether or not this is a dynamic view.")
    public boolean isDynamic() {
        return false;
    }

    @Override
    protected String getCfgSpec() {
        String[] baselineSelectors;
        Context.getLogger().info("Deriving config spec...");
        StringBuffer cfgSpecBuffer = new StringBuffer("element * CHECKEDOUT\n");
        if (StringUtils.isNotBlank((String)this.getBaselineSelectors())) {
            baselineSelectors = StringUtils.split((String)this.getBaselineSelectors(), (String)",");
        } else {
            baselineSelectors = StringUtils.split((String)this.getFoundationBaselines(), (String)",");
            cfgSpecBuffer.append("element * .../" + this.getStream() + "/LATEST\n");
        }
        Map<String, String> resolvedBaselines = this.resolveBaselines(baselineSelectors);
        for (Map.Entry<String, String> entry : resolvedBaselines.entrySet()) {
            String component = entry.getKey();
            String baseline = entry.getValue();
            String componentRootDir = this.getComponentRootDir(component);
            String label = this.getBaselineLabel(baseline);
            if (componentRootDir == null) continue;
            if (StringUtils.isBlank((String)this.getLoadRules())) {
                cfgSpecBuffer.append("load " + componentRootDir + "\n");
            }
            if (label == null) continue;
            cfgSpecBuffer.append("element " + componentRootDir + "/... " + label + "\n");
        }
        cfgSpecBuffer.append("element * /main/0\n");
        if (StringUtils.isNotBlank((String)this.getLoadRules())) {
            cfgSpecBuffer.append(this.getLoadRules());
        }
        String cfgSpec = cfgSpecBuffer.toString();
        Context.getLogger().info("Derived config spec:\n" + cfgSpec);
        return cfgSpec;
    }
}

