/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.plugin.scm.clearcase.View;
import com.pmease.quickbuild.plugin.scm.clearcase.ViewProvider;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=300, name="Use Existing Snapshot View")
@ScriptApi(value="This class specifies an existing snapshot view.")
public class ExistingSnapshotViewProvider
implements ViewProvider {
    private static final long serialVersionUID = 1L;
    private ClearCaseRepository repository;
    private String rootPath;
    private ProofBuildSupport proofBuildSupport;
    private transient View view;

    public ExistingSnapshotViewProvider(ClearCaseRepository repository) {
        this.repository = repository;
    }

    @Editable(order=100, name="View Root Directory", description="Specify absolute path to the root directory containing source code of an existing snapshot view. Under the root directory, you should be able to find file view.dat (or .view.dat).")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get view root path.")
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    @Editable(order=200, description="Check this to enable proof build for this view.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled.")
    public ProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(ProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @ScriptApi(value="Get repository object.")
    public ClearCaseRepository getRepository() {
        return this.repository;
    }

    @Override
    public View getView() {
        if (this.view == null) {
            final File rootDir = new File(this.getRootPath());
            if (!rootDir.isAbsolute()) {
                throw new QuickbuildException("Root path of the existing snapshot view should be specified as an absolute path.");
            }
            Commandline cmdline = this.repository.buildCleartoolCmd("catcs");
            final StringBuffer cfgSpecBuffer = new StringBuffer();
            final boolean[] isRootPathValid = new boolean[]{true};
            Commandline.ExecuteResult result = cmdline.execute(rootDir, this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (!line.contains("# by QuickBuild")) {
                        if (cfgSpecBuffer.length() == 0) {
                            cfgSpecBuffer.append(line);
                        } else {
                            cfgSpecBuffer.append("\n").append(line);
                        }
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                    if (line.contains("not a ClearCase object")) {
                        isRootPathValid[0] = false;
                    }
                }
            });
            if (!isRootPathValid[0]) {
                throw new QuickbuildException("Invalid view root directory: " + rootDir.getAbsolutePath());
            }
            if (result.getReturnCode() != 0) {
                throw result.buildException();
            }
            cmdline = this.repository.buildCleartoolCmd("lsview");
            cmdline.addArgLine("-cview");
            final StringBuffer nameBuffer = new StringBuffer();
            cmdline.execute(rootDir, this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.trim().length() != 0 && !line.startsWith("*")) {
                        nameBuffer.append(StringUtils.substringBefore((String)line.trim(), (String)" "));
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (nameBuffer.length() == 0) {
                throw new QuickbuildException("View root directory should point to a snapshot view.");
            }
            this.view = new View(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getCfgSpec() {
                    return cfgSpecBuffer.toString();
                }

                @Override
                public String getName() {
                    return nameBuffer.toString();
                }

                @Override
                public File getRootDir() {
                    return rootDir;
                }

                @Override
                public String getSubPaths() {
                    return StringUtils.join(ExistingSnapshotViewProvider.this.repository.getLoadPaths(this.getCfgSpec()), (String)"\n");
                }

                @Override
                public boolean isDynamic() {
                    return false;
                }
            };
        }
        return this.view;
    }

    public static class ProofBuildSupport
    extends ClearCaseProofBuildSupport {
        private static final long serialVersionUID = 1L;
        private ExistingSnapshotViewProvider viewProvider;

        public ProofBuildSupport(ExistingSnapshotViewProvider viewProvider) {
            this.viewProvider = viewProvider;
        }

        @Override
        public ClearCaseRepository getRepository() {
            return this.viewProvider.getRepository();
        }
    }
}

