/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.plugin.scm.clearcase.View;
import com.pmease.quickbuild.plugin.scm.clearcase.ViewProvider;
import java.io.File;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=400, name="Use Existing Dynamic View")
@ScriptApi(value="This class specifies an existing dynamic view.")
public class ExistingDynamicViewProvider
implements ViewProvider {
    private static final long serialVersionUID = 1L;
    private ClearCaseRepository repository;
    private String rootPath;
    private String subPaths;
    private transient View view;

    public ExistingDynamicViewProvider(ClearCaseRepository repository) {
        this.repository = repository;
    }

    @Editable(order=100, name="View Root Directory", description="Specify absolute path to the root directory containing source code of an existing dynamic view. Under this directory, you should see a list of mounted vob directories.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get view root path.")
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Editable(order=200, description="Specify relative sub paths underneath the view root directory specified above. Changes will be detected from these sub paths, and label operation will only apply to these sub paths. Multiple sub paths can be specified with one sub path per line.")
    @Multiline
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get sub paths used to detect changes and create labels under the view root directory.")
    public String getSubPaths() {
        return this.subPaths;
    }

    public void setSubPaths(String subPaths) {
        this.subPaths = subPaths;
    }

    @ScriptApi(value="Get repository object.")
    public ClearCaseRepository getRepository() {
        return this.repository;
    }

    @Override
    public View getView() {
        if (this.view == null) {
            File rootDir;
            String rootPath = this.getRootPath();
            if (rootPath.endsWith(":")) {
                rootPath = rootPath + "/";
            }
            if (!(rootDir = new File(rootPath)).isAbsolute()) {
                throw new QuickbuildException("Root path of the existing snapshot view should be specified as an absolute path.");
            }
            Commandline cmdline = this.repository.buildCleartoolCmd("catcs");
            final StringBuffer cfgSpecBuffer = new StringBuffer();
            final boolean[] isRootPathValid = new boolean[]{true};
            Commandline.ExecuteResult result = cmdline.execute(rootDir, this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (!line.contains("# by QuickBuild")) {
                        if (cfgSpecBuffer.length() == 0) {
                            cfgSpecBuffer.append(line);
                        } else {
                            cfgSpecBuffer.append("\n").append(line);
                        }
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                    if (line.contains("not a ClearCase object")) {
                        isRootPathValid[0] = false;
                    }
                }
            });
            if (!isRootPathValid[0]) {
                throw new QuickbuildException("Invalid view root directory: " + rootDir.getAbsolutePath());
            }
            if (result.getReturnCode() != 0) {
                throw result.buildException();
            }
            cmdline = this.repository.buildCleartoolCmd("lsview");
            cmdline.addArgLine("-cview");
            final StringBuffer nameBuffer = new StringBuffer();
            cmdline.execute(rootDir, this.repository.buildCommandEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith("*")) {
                        nameBuffer.append(StringUtils.substringBefore((String)line.substring(2), (String)" "));
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (nameBuffer.length() == 0) {
                throw new QuickbuildException("View root directory should point to a dynamic view.");
            }
            this.view = new View(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getCfgSpec() {
                    return cfgSpecBuffer.toString();
                }

                @Override
                public String getName() {
                    return nameBuffer.toString();
                }

                @Override
                public File getRootDir() {
                    return rootDir;
                }

                @Override
                public String getSubPaths() {
                    return ExistingDynamicViewProvider.this.getSubPaths();
                }

                @Override
                public boolean isDynamic() {
                    return true;
                }
            };
        }
        return this.view;
    }

    @Override
    public ClearCaseProofBuildSupport getProofBuildSupport() {
        return null;
    }
}

