/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ClearCaseSourceViewSupport
extends SourceViewSupport<ClearCaseRevision> {
    public ClearCaseSourceViewSupport(ClearCaseRepository repository) {
        super((Repository)repository);
    }

    public ClearCaseRepository getRepository() {
        return (ClearCaseRepository)super.getRepository();
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getView().getRootDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath != null && relativePath.length() != 0) {
            return relativePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        File tempDir = FileUtils.createTempDir((String)"ccreadsource");
        try {
            File destFile = new File(tempDir, "file");
            Commandline cmdline = this.getRepository().buildCleartoolCmd("get").addArgValue("-to").addArgValue(destFile.getAbsolutePath()).addArgValue(repositoryPath.substring(1) + "@@" + edition);
            cmdline.execute(this.getRepository().getView().getRootDir(), this.getRepository().buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            List list = FileUtils.readFileAsLines((File)destFile);
            return list;
        }
        finally {
            FileUtils.deleteDir((File)tempDir);
        }
    }

    public List<String> readSourceByRevision(String repositoryPath, final ClearCaseRevision revision) {
        Commandline cmdline = this.getRepository().buildCleartoolCmd("ls").addArgValue("-s").addArgValue(repositoryPath.substring(1));
        final String[] branch = new String[]{null};
        cmdline.execute(this.getRepository().getView().getRootDir(), this.getRepository().buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                String temp = StringUtils.replace((String)line, (String)"\\", (String)"/");
                temp = StringUtils.substringBeforeLast((String)temp, (String)"/");
                branch[0] = StringUtils.substringAfterLast((String)temp, (String)"/");
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        Validate.notNull((Object)branch[0]);
        cmdline = this.getRepository().buildCleartoolCmd("lshistory").addArgLine("-nco -branch").addArgValue(branch[0]).addArgValue("-fmt").addArgValue("%o ,%m ,%Nd ,%Vn \n").addArgValue(repositoryPath.substring(1));
        final String[] edition = new String[]{null};
        cmdline.execute(this.getRepository().getView().getRootDir(), this.getRepository().buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (edition[0] == null && line.startsWith("checkin ,version ,")) {
                    String[] fields = StringUtils.split((String)line.substring("checkin ,version ,".length()), (String)",");
                    Validate.isTrue((fields.length == 2 && fields[0].trim().length() != 0 && fields[1].trim().length() != 0 ? 1 : 0) != 0);
                    Date date = ClearCaseRepository.LOG_DATETIME_FORMATTER.parseDateTime(fields[0].trim()).toDate();
                    if (!date.after(revision.getValue())) {
                        edition[0] = fields[1].trim().replace("\\", "/");
                    }
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (edition[0] != null) {
            return this.readSourceByEdition(repositoryPath, edition[0]);
        }
        return null;
    }
}

