/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.clearcase.ChangeDetection;
import com.pmease.quickbuild.plugin.scm.clearcase.ChangeDetectionConfig;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCasePlugin;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRevision;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseSetting;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.clearcase.NewSnapshotViewFromCfgSpecProvider;
import com.pmease.quickbuild.plugin.scm.clearcase.View;
import com.pmease.quickbuild.plugin.scm.clearcase.ViewProvider;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.FlatChange;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.repositorysupport.WorkingDirLocator;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Editable(name="ClearCase", description="Configure a ClearCase repository here. By default, QuickBuild executes \"cleartool\" to checkout from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the ClearCase plugin through the plugin management page. There are some limitations of this repository, refer to <a href=\"$docroot/Working+with+ClearCase\" target=\"_blank\">the wiki</a> for details.")
@ScriptApi
public class ClearCaseRepository
extends Repository<ClearCaseRevision> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"dd-MMMM-yyyy.HH:mm:ss").withLocale(Locale.ENGLISH);
    static final DateTimeFormatter LOG_DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd.HHmmss");
    private static final String LOG_FIELD_SEPERATOR = "|##|";
    private static final String LOG_RECORD_PREFIX = "qb_cc_lr:";
    private static final String LOG_FILE_CHECKIN_RECORD_PREFIX = "checkin |##|version |##|";
    static final String TIMESTAMP_COMMENT = "# by QuickBuild";
    private ViewProvider viewProvider = new NewSnapshotViewFromCfgSpecProvider(this);
    private ChangeDetectionConfig changeDetectionConfig;
    private List<Property> environments;

    @Editable(order=200, name="View", description="Specify the ClearCase view to build against. We suggest to let QuickBuild creating view as necessary based on specified config spec or stream info, since it allows to checkout either from server or from agent. If the <b>Use Existing View</b> option is choosed, QuickBuild can only check out from server unless the specified view root directory refers to valid views both at server and at agent.")
    @NotNull
    @ScriptApi(value="Get view provider.")
    public ViewProvider getViewProvider() {
        return this.viewProvider;
    }

    public void setViewProvider(ViewProvider viewProvider) {
        this.viewProvider = viewProvider;
    }

    @Editable(order=300, description="Optionally specify from which branch and path to detect changes. If not specified, QuickBuild will detect changes from all branches of all load paths in the config spec.")
    public ChangeDetectionConfig getChangeDetectionConfig() {
        return this.changeDetectionConfig;
    }

    public void setChangeDetectionConfig(ChangeDetectionConfig changeDetectionConfig) {
        this.changeDetectionConfig = changeDetectionConfig;
    }

    @ScriptApi(value="Get view object.")
    public View getView() {
        return this.getViewProvider().getView();
    }

    private boolean cfgSpecEquals(String cfgSpec1, String cfgSpec2) {
        cfgSpec1 = this.normalizeCfgSpec(cfgSpec1);
        cfgSpec2 = this.normalizeCfgSpec(cfgSpec2);
        return cfgSpec1.equals(cfgSpec2);
    }

    protected void checkoutByRevision(ClearCaseRevision revision) {
        if (this.getView().isDynamic() || this.viewDatExists()) {
            String timestampedCfgSpec = this.getTimestampedCfgSpec(revision.getValue());
            if (!this.cfgSpecEquals(this.getLiveCfgSpec(), timestampedCfgSpec)) {
                Context.getLogger().info("Time stamping config spec of view '" + this.getView().getName() + "'...");
                this.updateCfgSpec(timestampedCfgSpec);
            }
        } else {
            this.restoreViewDat();
            String timestampedCfgSpec = this.getTimestampedCfgSpec(revision.getValue());
            if (!this.cfgSpecEquals(this.getLiveCfgSpec(), timestampedCfgSpec)) {
                Context.getLogger().info("Time stamping config spec of view '" + this.getView().getName() + "'...");
                this.updateCfgSpec(timestampedCfgSpec);
                if (StringUtils.deleteWhitespace((String)timestampedCfgSpec).contains("element*/main/0-mkbranch")) {
                    this.updateView();
                }
            } else {
                Context.getLogger().info("Restoring files of view '" + this.getView().getName() + "'...");
                this.updateView();
            }
        }
    }

    void ensureUpToDate(Date revision) {
        if (this.isLocalChangeApplied()) {
            this.revertLocalChange();
        }
        if (this.getView().isDynamic() || this.viewDatExists()) {
            Date timestamp = this.getTimestamp(this.getLiveCfgSpec());
            if (timestamp == null || timestamp.before(revision)) {
                String timestampedCfgSpec = this.getTimestampedCfgSpec(revision);
                Context.getLogger().info("Time stamping config spec of view '" + this.getView().getName() + "'...");
                this.updateCfgSpec(timestampedCfgSpec);
            }
        } else {
            this.restoreViewDat();
            Date timestamp = this.getTimestamp(this.getLiveCfgSpec());
            if (timestamp == null || timestamp.before(revision)) {
                String timestampedCfgSpec = this.getTimestampedCfgSpec(revision);
                Context.getLogger().info("Time stamping config spec of view '" + this.getView().getName() + "'...");
                this.updateCfgSpec(timestampedCfgSpec);
                if (StringUtils.deleteWhitespace((String)timestampedCfgSpec).contains("element*/main/0-mkbranch")) {
                    this.updateView();
                }
            } else {
                Context.getLogger().info("Restoring files of view '" + this.getView().getName() + "'...");
                this.updateView();
            }
        }
    }

    private String getTimestampedCfgSpec(Date timestamp) {
        String timestampedCfgSpec = "time " + DATETIME_FORMATTER.print((ReadableInstant)new DateTime((Object)timestamp)) + " " + TIMESTAMP_COMMENT + "\n" + this.getView().getCfgSpec() + "\nend time " + TIMESTAMP_COMMENT;
        return timestampedCfgSpec;
    }

    protected ClearCaseRevision getHeadRevision() {
        return new ClearCaseRevision(DATETIME_FORMATTER.parseDateTime(DATETIME_FORMATTER.print((ReadableInstant)new DateTime())).toDate());
    }

    public SourceViewSupport<ClearCaseRevision> getSourceViewSupport() {
        return new WorkingDirLocator((SourceViewSupport)new ClearCaseSourceViewSupport(this));
    }

    protected void labelOnRevision(ClearCaseRevision revision, String label, String comment) {
        if (this.isLocalChangeApplied()) {
            this.revertLocalChange();
        }
        this.checkoutByRevision(revision);
        for (String subPath : this.normalizeSubPaths()) {
            File subDir = new File(this.getView().getRootDir(), subPath);
            Commandline cmdline = this.buildCleartoolCmd("lstype");
            cmdline.addArgValue("-s").addArgValue("lbtype:" + label);
            final boolean[] labelExists = new boolean[]{true};
            Commandline.ExecuteResult result = cmdline.execute(subDir, this.buildCommandEnv(), (OutputStream)new LineConsumer.NoOp(), new LineConsumer(){

                public void consume(String line) {
                    if (line.contains("Label type not found:")) {
                        labelExists[0] = false;
                    } else {
                        Context.getLogger().error(line);
                    }
                }
            });
            if (result.getReturnCode() != 0 && labelExists[0]) {
                throw result.buildException();
            }
            cmdline = this.buildCleartoolCmd("mklbtype");
            if (labelExists[0]) {
                cmdline.addArgValue("-replace");
            }
            cmdline.addArgValue("-c").addArgValue(comment).addArgValue(label);
            cmdline.execute(subDir, this.buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            cmdline = this.buildCleartoolCmd("mklabel");
            if (labelExists[0]) {
                cmdline.addArgValue("-replace");
            }
            cmdline.addArgLine("-recurse -c").addArgValue(comment).addArgValue(label).addArgValue(".");
            cmdline.execute(subDir, this.buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        }
    }

    private ClearCaseSetting getClearCaseSetting() {
        return (ClearCaseSetting)PluginSettingHelper.getSetting(ClearCasePlugin.class, (boolean)true);
    }

    Commandline buildCleartoolCmd(String command) {
        Commandline cmdline = new Commandline();
        String cleartoolExe = this.getClearCaseSetting().getCleartoolPath();
        if (cleartoolExe == null) {
            cleartoolExe = "cleartool";
        }
        cmdline.setExecutable(cleartoolExe);
        cmdline.createArgument().setValue(command);
        return cmdline;
    }

    private String getLiveCfgSpec() {
        Commandline cmdline = this.buildCleartoolCmd("catcs");
        cmdline.addArgLine("-tag " + this.getView().getName());
        final StringBuffer buffer = new StringBuffer();
        cmdline.execute(this.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (buffer.length() == 0) {
                    buffer.append(line);
                } else {
                    buffer.append("\n").append(line);
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return buffer.toString().trim();
    }

    private Date getTimestamp(String cfgSpec) {
        for (String line : StringUtils.splitAndTrim((String)cfgSpec, (String)"\n")) {
            if (!line.contains(TIMESTAMP_COMMENT)) continue;
            line = StringUtils.substringAfter((String)line, (String)" ");
            line = StringUtils.substringBefore((String)line, (String)" ");
            return DATETIME_FORMATTER.parseDateTime(line).toDate();
        }
        return null;
    }

    void createView(String name, String streamSelector, String mkviewOptions, File rootDir) {
        Commandline cmdline = this.buildCleartoolCmd("mkview");
        cmdline.addArgLine("-snapshot -tag " + name);
        if (streamSelector != null) {
            cmdline.addArgLine("-stream " + streamSelector);
        }
        if (mkviewOptions != null) {
            cmdline.addArguments(StringUtils.parseQuoteTokens((String)mkviewOptions));
        }
        cmdline.addArgValue(rootDir.getAbsolutePath());
        FileUtils.deleteDir((File)rootDir);
        cmdline.execute(this.buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    private void restoreViewDat() {
        Commandline cmdline = this.buildCleartoolCmd("lsview");
        cmdline.addArgValue("-l").addArgValue(this.getView().getName());
        final String[] uuid = new String[]{null};
        cmdline.execute(this.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("View uuid: ")) {
                    uuid[0] = StringUtils.substringAfter((String)line, (String)"View uuid: ");
                }
                Context.getLogger().debug(line);
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        Validate.notNull((Object)uuid[0]);
        File viewDatFile = SystemUtils.IS_OS_WINDOWS ? new File(this.getView().getRootDir(), "view.dat") : new File(this.getView().getRootDir(), ".view.dat");
        FileUtils.writeFile((File)viewDatFile, (String)("ws_oid:00000000000000000000000000000000 view_uuid:" + uuid[0]));
    }

    boolean viewDatExists() {
        return new File(this.getView().getRootDir(), "view.dat").exists() || new File(this.getView().getRootDir(), ".view.dat").exists();
    }

    void updateView() {
        this.deleteUpdateLogs();
        Commandline cmdline = this.buildCleartoolCmd("update");
        cmdline.execute(this.getView().getRootDir(), this.buildCommandEnv(), (OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("Log has been written to")) {
                    Context.getLogger().debug(line);
                } else {
                    Context.getLogger().error(line);
                }
            }
        }, "yes" + Constants.LINE_SEPARATOR).checkReturnCode();
    }

    private String normalizeCfgSpec(String cfgSpec) {
        List lines = StringUtils.splitAndTrim((String)cfgSpec, (String)"\r\n");
        cfgSpec = StringUtils.join((Collection)lines, (String)Constants.LINE_SEPARATOR);
        return cfgSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCfgSpec(String cfgSpec) {
        this.deleteUpdateLogs();
        cfgSpec = this.normalizeCfgSpec(cfgSpec);
        File cfgSpecFile = FileUtils.createTempFile((String)"cfgspec");
        try {
            FileUtils.writeFile((File)cfgSpecFile, (String)cfgSpec);
            Commandline cmdline = this.buildCleartoolCmd("setcs");
            cmdline.addArgValue(cfgSpecFile.getAbsolutePath());
            cmdline.execute(this.getView().getRootDir(), this.buildCommandEnv(), (OutputStream)new LineConsumer.NoOp(), new LineConsumer(){

                public void consume(String line) {
                    if (line.startsWith("Log has been written to")) {
                        Context.getLogger().debug(line);
                    } else {
                        Context.getLogger().error(line);
                    }
                }
            }, "yes" + Constants.LINE_SEPARATOR).checkReturnCode();
        }
        finally {
            FileUtils.deleteFile((File)cfgSpecFile);
        }
    }

    private void deleteUpdateLogs() {
        for (File file : this.getView().getRootDir().listFiles()) {
            if (!file.getName().endsWith(".updt")) continue;
            FileUtils.deleteFile((File)file);
        }
    }

    protected List<Changeset> getChangesBetween(ClearCaseRevision startRevision, final ClearCaseRevision endRevision) {
        List<ChangeDetection> detections = this.getChangeDetections();
        if (detections.isEmpty()) {
            return new ArrayList<Changeset>();
        }
        this.ensureUpToDate(endRevision.getValue());
        final ArrayList<FlatChange> checkinRecords = new ArrayList<FlatChange>();
        final HashSet<String> checkinPaths = new HashSet<String>();
        for (ChangeDetection detection : detections) {
            Context.getLogger().info("Getting changes on branch '" + detection.getBranch() + "'...");
            Commandline cmdline = this.buildCleartoolCmd("lshistory");
            cmdline.createArgument().setLine("-nco -branch");
            cmdline.createArgument().setValue(detection.getBranch());
            cmdline.createArgument().setLine("-r -since");
            cmdline.createArgument().setValue(DATETIME_FORMATTER.print((ReadableInstant)new DateTime((Object)startRevision.getValue())));
            cmdline.createArgument().setValue("-fmt");
            cmdline.createArgument().setValue("qb_cc_lr:%o |##|%m |##|%Nd |##|%En |##|%Vn |##|%u |##|%[activity]p |##| %c\n");
            for (String subPath : StringUtils.splitAndTrim((String)detection.getPath())) {
                cmdline.createArgument().setValue(subPath);
            }
            final FlatChange checkinRecord = new FlatChange();
            final boolean[] errorous = new boolean[]{false};
            Commandline.ExecuteResult result = cmdline.execute(this.getView().getRootDir(), this.buildCommandEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith(ClearCaseRepository.LOG_RECORD_PREFIX)) {
                        String record;
                        if (checkinRecord.getComment() != null) {
                            checkinRecords.add(checkinRecord.clone());
                            checkinRecord.reset();
                        }
                        if ((record = line.substring(ClearCaseRepository.LOG_RECORD_PREFIX.length())).startsWith(ClearCaseRepository.LOG_FILE_CHECKIN_RECORD_PREFIX)) {
                            String fileCheckinRecord = record.substring(ClearCaseRepository.LOG_FILE_CHECKIN_RECORD_PREFIX.length());
                            String[] fields = StringUtils.splitByWholeSeparator((String)fileCheckinRecord, (String)ClearCaseRepository.LOG_FIELD_SEPERATOR);
                            Date date = LOG_DATETIME_FORMATTER.parseDateTime(fields[0].trim()).toDate();
                            Context.getLogger().debug("Comparing log entry date with end revision date (log entry:" + date + ", end revision: " + endRevision.getValue() + ")");
                            if (!date.after(endRevision.getValue())) {
                                String path = StringUtils.replace((String)fields[1].trim(), (String)"\\", (String)"/");
                                checkinPaths.add(path);
                                checkinRecord.setDate(date);
                                checkinRecord.setPath(path);
                                checkinRecord.setEdition(StringUtils.replace((String)fields[2].trim(), (String)"\\", (String)"/"));
                                checkinRecord.setUser(fields[3].trim());
                                Context.getLogger().debug("Found checkin record (path:" + checkinRecord.getPath() + ", edition:" + checkinRecord.getEdition() + ")");
                                checkinRecord.setChangesetId(null);
                                checkinRecord.setComment(fields[5].trim());
                            }
                        }
                    } else if (checkinRecord.getComment() != null) {
                        if (checkinRecord.getComment().length() == 0) {
                            checkinRecord.setComment(line);
                        } else {
                            checkinRecord.setComment(checkinRecord.getComment() + "\n" + line);
                        }
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                    if (!line.contains("Branch type not found")) {
                        errorous[0] = true;
                    }
                }
            });
            if (errorous[0]) {
                throw result.buildException();
            }
            if (checkinRecord.getComment() == null) continue;
            checkinRecords.add(checkinRecord);
        }
        Map<String, String> pathVersions = this.getPathVersions(checkinPaths);
        Iterator it = checkinRecords.iterator();
        while (it.hasNext()) {
            FlatChange record = (FlatChange)it.next();
            Context.getLogger().debug("Checking checkin path: " + record.getPath());
            String currentVersion = pathVersions.get(record.getPath());
            if (currentVersion != null) {
                Context.getLogger().debug("Current version: " + currentVersion);
                String currentBranch = StringUtils.substringBeforeLast((String)currentVersion, (String)"/").trim();
                String checkinBranch = StringUtils.substringBeforeLast((String)record.getEdition(), (String)"/").trim();
                Context.getLogger().debug("Current branch: " + currentBranch);
                Context.getLogger().debug("Checkin branch: " + checkinBranch);
                if (currentBranch.equals(checkinBranch)) {
                    record.setPath("/" + record.getPath());
                    String checkinVersionOnBranch = StringUtils.substringAfterLast((String)record.getEdition(), (String)"/");
                    if (checkinVersionOnBranch.equals("1")) {
                        record.setAction(Modification.Action.ADD);
                        continue;
                    }
                    record.setAction(Modification.Action.MODIFY);
                    record.setPreviousEdition(checkinBranch + "/" + String.valueOf(Integer.parseInt(checkinVersionOnBranch) - 1));
                    continue;
                }
            }
            it.remove();
        }
        List changesets = FlatChange.aggregate(checkinRecords);
        for (Changeset each : changesets) {
            each.setId(UUID.randomUUID().toString());
        }
        return changesets;
    }

    private Map<String, String> getPathVersions(Set<String> paths) {
        HashMap<String, String> pathVersions = new HashMap<String, String>();
        Commandline cmdline = this.buildCleartoolCmd("ls");
        cmdline.createArgument().setValue("-s");
        for (String path : paths) {
            if (!cmdline.willOverflow(path)) {
                cmdline.createArgument().setValue(path);
                continue;
            }
            this.fillPathVersions(cmdline, pathVersions);
            cmdline = this.buildCleartoolCmd("ls");
            cmdline.createArgument().setValue("-s");
        }
        if (cmdline.getArgumentParts().length > 2) {
            this.fillPathVersions(cmdline, pathVersions);
        }
        return pathVersions;
    }

    private void fillPathVersions(Commandline cmdline, final Map<String, String> pathVersions) {
        final boolean[] commandFailed = new boolean[]{false};
        Commandline.ExecuteResult result = cmdline.execute(this.getView().getRootDir(), this.buildCommandEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                line = StringUtils.replace((String)line, (String)"\\", (String)"/");
                pathVersions.put(StringUtils.substringBefore((String)line, (String)"@@"), StringUtils.substringAfter((String)line, (String)"@@"));
            }
        }, new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().warn(line);
                if (!line.endsWith("No such file or directory.")) {
                    commandFailed[0] = true;
                }
            }
        });
        if (commandFailed[0]) {
            throw result.buildException();
        }
    }

    @ScriptApi(value="Get revision of the repository.")
    public ClearCaseRevision getRevision() {
        return (ClearCaseRevision)super.getRevision();
    }

    private Set<String> getBranches(String cfgSpec) {
        HashSet<String> branches = new HashSet<String>();
        Pattern branchPattern = Pattern.compile("[/\\\\]([^/|\\\\]*)[/\\\\]LATEST");
        for (String line : StringUtils.splitAndTrim((String)cfgSpec, (String)"\r\n")) {
            line = StringUtils.substringBefore((String)line, (String)"#");
            Matcher matcher = branchPattern.matcher(line);
            while (matcher.find()) {
                branches.add(matcher.group(1));
            }
        }
        return branches;
    }

    Set<String> getLoadPaths(String cfgSpec) {
        HashSet<String> loadPaths = new HashSet<String>();
        for (String line : StringUtils.splitAndTrim((String)cfgSpec, (String)"\n;")) {
            if (!line.toLowerCase().startsWith("load ")) continue;
            String loadPath = StringUtils.replace((String)line.substring("load ".length()).trim(), (String)"\\", (String)"/");
            loadPath = StringUtils.stripStart((String)loadPath, (String)"\"'");
            loadPath = StringUtils.stripEnd((String)loadPath, (String)"\"'");
            loadPaths.add(loadPath);
        }
        return loadPaths;
    }

    protected boolean isQuietSince(Date date) {
        return this.getChangesBetween(new ClearCaseRevision(date), new ClearCaseRevision(new Date())).isEmpty();
    }

    Set<String> normalizeSubPaths() {
        HashSet<String> normalized = new HashSet<String>();
        for (String subpath : StringUtils.splitAndTrim((String)this.getView().getSubPaths())) {
            subpath = StringUtils.stripStart((String)StringUtils.replace((String)subpath, (String)"\\", (String)"/"), (String)"/");
            normalized.add(subpath);
        }
        return normalized;
    }

    private List<ChangeDetection> getChangeDetections() {
        ArrayList<ChangeDetection> detections = new ArrayList<ChangeDetection>();
        if (this.getChangeDetectionConfig() != null) {
            for (ChangeDetection each : this.getChangeDetectionConfig().getChangeDetections()) {
                ChangeDetection detection = new ChangeDetection();
                detection.setBranch(each.getBranch());
                detection.setPath(StringUtils.stripStart((String)StringUtils.replace((String)each.getPath().trim(), (String)"\\", (String)"/"), (String)"/"));
                detections.add(detection);
            }
        } else {
            String paths = StringUtils.join(this.normalizeSubPaths(), (String)",");
            for (String branch : this.getBranches(this.getView().getCfgSpec())) {
                ChangeDetection detection = new ChangeDetection();
                detection.setBranch(branch);
                detection.setPath(paths);
                detections.add(detection);
            }
        }
        return detections;
    }

    public ProofBuildSupport<? extends LocalChange> getProofBuildSupport() {
        return this.getViewProvider().getProofBuildSupport();
    }

    @Editable(name="Environment Variables", order=1200, description="Specify environment variables when execute cleartool command.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @Advanced
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    public Environment buildCommandEnv() {
        List<Property> properties = this.getEnvironments();
        if (properties == null) {
            properties = new ArrayList<Property>();
        }
        Environment env = new Environment();
        for (Property each : properties) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        return env;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element rootElement = dom.getRootElement();
        String viewName = rootElement.elementText("viewName");
        rootElement.element("viewName").detach();
        Element viewPathElement = rootElement.element("viewPath");
        String rootPath = null;
        if (viewPathElement != null) {
            rootPath = viewPathElement.getText();
            viewPathElement.detach();
        }
        String mkviewOptions = null;
        Element mkviewOptionsElement = rootElement.element("mkviewOptions");
        if (mkviewOptionsElement != null) {
            mkviewOptions = mkviewOptionsElement.getText();
            mkviewOptionsElement.detach();
        }
        Element viewProviderElement = rootElement.addElement("viewProvider");
        viewProviderElement.addElement("repository").addAttribute("reference", "../..");
        Element proofBuildSupportElement = rootElement.element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.detach();
            proofBuildSupportElement.element("localViewPath").setName("localViewRoot");
            proofBuildSupportElement.element("repository").setName("viewProvider");
            viewProviderElement.add(proofBuildSupportElement);
        }
        Element cfgSpecProviderElement = rootElement.element("configSpecProvider");
        cfgSpecProviderElement.detach();
        if (cfgSpecProviderElement.attributeValue("class").contains("UCM")) {
            String baselineSelectors;
            viewProviderElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.NewViewFromStreamProvider");
            viewProviderElement.addElement("streamSelector").setText(cfgSpecProviderElement.elementText("streamSelector"));
            if (rootPath != null) {
                viewProviderElement.addElement("rootPath").setText(rootPath);
            }
            if (mkviewOptions != null) {
                viewProviderElement.addElement("mkviewOpts").setText(mkviewOptions);
            }
            viewProviderElement.addElement("viewName").setText(viewName);
            String loadRules = cfgSpecProviderElement.elementText("loadRules");
            if (loadRules != null) {
                viewProviderElement.addElement("loadRules").setText(loadRules);
            }
            if ((baselineSelectors = cfgSpecProviderElement.elementText("baselineSelectors")) != null) {
                viewProviderElement.addElement("baselineSelectors").setText(baselineSelectors);
            }
        } else {
            viewProviderElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.NewViewFromCfgSpecProvider");
            viewProviderElement.addElement("viewName").setText(viewName);
            if (rootPath != null) {
                viewProviderElement.addElement("rootPath").setText(rootPath);
            }
            if (mkviewOptions != null) {
                viewProviderElement.addElement("mkviewOpts").setText(mkviewOptions);
            }
            viewProviderElement.addElement("cfgSpec").setText(cfgSpecProviderElement.elementText("configSpec"));
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element viewProviderElement = dom.getRootElement().element("viewProvider");
        if (viewProviderElement.attributeValue("class").contains("NewView") && viewProviderElement.element("viewName") == null) {
            viewProviderElement.addElement("viewName").setText("qb-${node.hostName}-${current.viewDirId}");
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        Element viewProviderElement = dom.getRootElement().element("viewProvider");
        String clazz = viewProviderElement.attributeValue("class");
        clazz = clazz.replace("NewViewFromCfgSpecProvider", "NewSnapshotViewFromCfgSpecProvider");
        clazz = clazz.replace("NewViewFromStreamProvider", "NewSnapshotViewFromStreamProvider");
        viewProviderElement.attribute("class").setValue(clazz);
        Element viewNameElement = viewProviderElement.element("viewName");
        if (viewNameElement != null) {
            String viewName = viewNameElement.getText().trim();
            viewNameElement.clearContent();
            viewNameElement.setName("viewNameProvider");
            viewNameElement.addElement("viewProvider").addAttribute("reference", "../..");
            if (viewName.equals("qb-${node.hostName}-${current.viewDirId}")) {
                viewNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.NodeAndDirBasedViewName");
            } else {
                viewNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.SpecifiedViewName").addElement("viewName").setText(viewName);
            }
        }
    }

    private void migrate6(VersionedDocument dom, Stack<Integer> versions) {
        Element proofBuildSupportElement = dom.getRootElement().element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }

    private void migrate7(VersionedDocument dom, Stack<Integer> versions) {
        Element viewProviderElement = dom.getRootElement().element("viewProvider");
        Element proofBuildSupportElement = viewProviderElement.element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }
}

