/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.clearcase;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.util.Triple;
import java.io.File;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Proof build support object for ClearCase repository.")
public abstract class ClearCaseProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private static final String CHECKOUT_RECORD_PREFIX = "qb-cc-pf:";
    private String localViewRoot;
    private String updateCondition = "true";
    private String checkinCondition = "build.successful";
    private String checkinComment;
    private String checkinOptions = "-identical";

    @Editable(order=100, name="Local View Root Directory", description="Specify the absolute path to the view root directory at user's desktop. Changes that have not been checked in will be collected from the local view and send to build grid to run a proof build.")
    @NotEmpty
    @ScriptApi(value="Get absolute path to local view root directory at user's desktop.")
    @Scriptable
    public String getLocalViewRoot() {
        return this.localViewRoot;
    }

    public void setLocalViewRoot(String localViewRoot) {
        this.localViewRoot = localViewRoot;
    }

    @Editable(order=200, description="If local view path specified above points to a snapshot view, you may specify the condition to update the view. If this condition is satisfied, the snapshot view will be updated before local change is collected. Updating view will make the proof build more accurate and it is recommended that you set this condition to <b>true</b>.<br><strong>NOTE: </strong> This option will be ignored if you've specified a dynamic view.")
    @Expressions(value={"always update", "true", "do not update", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to update local view.")
    @Scriptable
    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    @Editable(order=300, description="Specify the condition to checkin local change. If this condition is satisfied, change in the local view will be checked in after the build finishes.")
    @Expressions(value={"checkin only when build is successful", "build.successful", "always checkin", "true", "do not checkin", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to checkin local change after proof build finishes.")
    @Scriptable
    public String getCheckinCondition() {
        return this.checkinCondition;
    }

    public void setCheckinCondition(String checkinCondition) {
        this.checkinCondition = checkinCondition;
    }

    @Editable(order=400, description="Specify the comment when checkin the local change. This property only takes effect if the checkin condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get checkin comment of local change. Null if not specified.")
    @Scriptable
    public String getCheckinComment() {
        return this.checkinComment;
    }

    public void setCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
    }

    @Editable(order=500, description="Specify options to cleartool \"checkin\" sub command when checkin the local change. This property only takes effect if the checkin condition specified above is satisfied.")
    @ScriptApi(value="Get additional checkin options. Null if not specified.")
    @Scriptable
    public String getCheckinOptions() {
        return this.checkinOptions;
    }

    public void setCheckinOptions(String promoteOptions) {
        this.checkinOptions = promoteOptions;
    }

    private Set<String> getMountedVobs() {
        final HashSet<String> mountedVobs = new HashSet<String>();
        Commandline cmdline = this.getRepository().buildCleartoolCmd("lsvob");
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith("*")) {
                    mountedVobs.add(StringUtils.split((String)line)[1]);
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return mountedVobs;
    }

    public void buildFinished() {
        Boolean isCheckin = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getCheckinCondition(), Context.buildEvalContext((Object)((Object)this.getRepository()), null));
        if (isCheckin.booleanValue()) {
            Context.getLogger().info("Checkin local change...");
            Commandline cmdline = this.getRepository().buildCleartoolCmd("lsco").addArgLine("-cview -all -fmt").addArgValue("%En\n");
            if (this.isDynamicView()) {
                for (String vob : this.getMountedVobs()) {
                    cmdline.addArgValue(vob.substring(1));
                }
            } else {
                for (String vob : this.getRepository().getLoadPaths(this.getLocalViewCfgSpec())) {
                    cmdline.addArgValue(vob.substring(1));
                }
            }
            final LinkedList checkoutPaths = new LinkedList();
            cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    line = StringUtils.stripEnd((String)line, (String)".");
                    if (line.startsWith(ClearCaseProofBuildSupport.this.getLocalViewDir().getAbsolutePath())) {
                        line = FileUtils.getRelativePath((String)line, (String)ClearCaseProofBuildSupport.this.getLocalViewDir().getAbsolutePath());
                    }
                    Validate.isTrue((boolean)StringUtils.isNotBlank((String)line));
                    checkoutPaths.add(line.substring(1));
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            cmdline = this.buildCheckinCmd();
            boolean pathAppended = false;
            for (String path : checkoutPaths) {
                if (!cmdline.willOverflow(path)) {
                    cmdline.addArgValue(path);
                    pathAppended = true;
                    continue;
                }
                cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                cmdline = this.buildCheckinCmd();
                pathAppended = false;
            }
            if (pathAppended) {
                cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
        }
    }

    private Commandline buildCheckinCmd() {
        Commandline cmdline = this.getRepository().buildCleartoolCmd("checkin");
        if (this.getCheckinComment() != null) {
            cmdline.addArgValue("-comment").addArgValue(this.getCheckinComment());
        } else {
            cmdline.addArgValue("-ncomment");
        }
        if (this.getCheckinOptions() != null) {
            cmdline.addArgLine(this.getCheckinOptions());
        }
        return cmdline;
    }

    public File getCheckoutFile(String repositoryPath) {
        return new File(this.getRepository().getView().getRootDir(), repositoryPath);
    }

    private File getLocalViewDir() {
        String normalized = FilenameUtils.normalizeNoEndSeparator((String)this.getLocalViewRoot());
        normalized = normalized.substring(0, 1).toUpperCase() + normalized.substring(1);
        return new File(normalized);
    }

    private String getLocalViewCfgSpec() {
        Commandline cmdline = this.getRepository().buildCleartoolCmd("catcs");
        final StringBuffer buffer = new StringBuffer();
        cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                buffer.append(line + "\n");
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return buffer.toString();
    }

    private boolean isDynamicView() {
        Commandline cmdline = this.getRepository().buildCleartoolCmd("lsview");
        cmdline.addArgValue("-cview");
        final boolean[] isDynamic = new boolean[]{false};
        cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith("*")) {
                    isDynamic[0] = true;
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return isDynamic[0];
    }

    public LocalChange getLocalChange(File changeStoreDir) {
        File storedFile;
        File file;
        Boolean isUpdate;
        boolean isDynamicView = this.isDynamicView();
        if (!isDynamicView && (isUpdate = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getUpdateCondition(), Context.buildEvalContext((Object)((Object)this.getRepository()), null))).booleanValue()) {
            Context.getLogger().info("Updating local view...");
            for (File file2 : this.getLocalViewDir().listFiles()) {
                if (!file2.getName().endsWith(".updt")) continue;
                FileUtils.deleteFile((File)file2);
            }
            Commandline cmdline = this.getRepository().buildCleartoolCmd("update");
            cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer.NoOp(), new LineConsumer(){

                public void consume(String line) {
                    if (line.startsWith("Log has been written to")) {
                        Context.getLogger().debug(line);
                    } else {
                        Context.getLogger().error(line);
                    }
                }
            }).checkReturnCode();
        }
        Commandline cmdline = this.getRepository().buildCleartoolCmd("lsco");
        cmdline.createArgument().setLine("-cview -all -fmt");
        cmdline.createArgument().setValue("qb-cc-pf:%En,%PVn,%Rf\n%c");
        if (isDynamicView) {
            for (String vob : this.getMountedVobs()) {
                cmdline.createArgument().setValue(vob.substring(1));
            }
        } else {
            for (String subpath : this.getRepository().getLoadPaths(this.getLocalViewCfgSpec())) {
                cmdline.createArgument().setValue(subpath.substring(1));
            }
        }
        final String[] checkoutPath = new String[]{null};
        final LinkedList checkouts = new LinkedList();
        final HashSet adds = new HashSet();
        final HashSet deletes = new HashSet();
        final LocalChange change = new LocalChange();
        cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith(ClearCaseProofBuildSupport.CHECKOUT_RECORD_PREFIX)) {
                    if (!adds.isEmpty() || !deletes.isEmpty()) {
                        Validate.notNull((Object)checkoutPath[0]);
                        for (String add : adds) {
                            change.getAddPaths().add(checkoutPath[0] + "/" + add);
                        }
                        for (String delete : deletes) {
                            change.getDeletePaths().add(checkoutPath[0] + "/" + delete);
                        }
                        adds.clear();
                        deletes.clear();
                    }
                    String record = line.substring(ClearCaseProofBuildSupport.CHECKOUT_RECORD_PREFIX.length()).replace('\\', '/');
                    String checkoutType = StringUtils.substringAfterLast((String)record, (String)",");
                    String tempStr = StringUtils.substringBeforeLast((String)record, (String)",");
                    checkoutPath[0] = StringUtils.substringBeforeLast((String)tempStr, (String)",");
                    checkoutPath[0] = StringUtils.stripEnd((String)checkoutPath[0], (String)"./");
                    checkoutPath[0] = checkoutPath[0].startsWith(ClearCaseProofBuildSupport.this.getLocalViewDir().getAbsolutePath().replace('\\', '/')) ? FileUtils.getRelativePath((String)checkoutPath[0], (String)ClearCaseProofBuildSupport.this.getLocalViewDir().getAbsolutePath()) : StringUtils.stripEnd((String)checkoutPath[0], (String)"/");
                    Validate.isTrue((boolean)StringUtils.isNotBlank((String)checkoutPath[0]));
                    String checkoutVersion = StringUtils.substringAfterLast((String)tempStr, (String)",");
                    checkouts.add(new Triple((Object)checkoutPath[0], (Object)checkoutVersion, (Object)checkoutType));
                } else if (line.startsWith("Added file element ") || line.startsWith("Added directory element ")) {
                    String elementName = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)line, (String)"\""), (String)"\"");
                    adds.add(elementName);
                    deletes.remove(elementName);
                } else if (line.startsWith("Removed file element ") || line.startsWith("Removed directory element ") || line.startsWith("Uncataloged file element ") || line.startsWith("Uncataloged directory element ")) {
                    String elementName = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)line, (String)"\""), (String)"\"");
                    deletes.add(elementName);
                    adds.remove(elementName);
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (!adds.isEmpty() || !deletes.isEmpty()) {
            Validate.notNull((Object)checkoutPath[0]);
            for (String add : adds) {
                change.getAddPaths().add(checkoutPath[0] + "/" + add);
            }
            for (String delete : deletes) {
                change.getDeletePaths().add(checkoutPath[0] + "/" + delete);
            }
        }
        LinkedList<String> needMerges = new LinkedList<String>();
        for (Triple checkout : checkouts) {
            String path = (String)checkout.getFirst();
            final String checkoutVersion = (String)checkout.getSecond();
            String checkoutType = (String)checkout.getThird();
            if (checkoutType.equals("unreserved")) {
                cmdline = this.getRepository().buildCleartoolCmd("lsvtree").addArgLine("-s -merge").addArgValue(path.substring(1));
                final Boolean[] merged = new Boolean[]{null};
                final String[] version = new String[]{null};
                cmdline.execute(this.getLocalViewDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().debug(line);
                        line = line.replace('\\', '/');
                        if (line.startsWith("  -> ")) {
                            if (ClearCaseProofBuildSupport.this.isSuccessorVersion(version[0], checkoutVersion) && line.substring("  -> ".length()).equals(StringUtils.substringBeforeLast((String)checkoutVersion, (String)"/") + "/CHECKEDOUT")) {
                                merged[0] = true;
                            }
                        } else {
                            version[0] = StringUtils.substringAfterLast((String)line, (String)"@@");
                            if (ClearCaseProofBuildSupport.this.isSuccessorVersion(version[0], checkoutVersion)) {
                                merged[0] = false;
                            }
                        }
                    }
                }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                if (merged[0] != null && !merged[0].booleanValue()) {
                    needMerges.add(path);
                }
            }
            if (change.getAddPaths().contains(path) || change.getDeletePaths().contains(path) || !new File(this.getLocalViewDir(), path).isFile()) continue;
            change.getModifyPaths().add(path);
        }
        if (needMerges.size() != 0) {
            throw new QuickbuildException("Below elements have new version on the checkout branch. Please merge them first:\n" + StringUtils.join(needMerges, (String)","));
        }
        for (String path : change.getAddPaths()) {
            file = new File(this.getLocalViewDir(), path);
            storedFile = new File(changeStoreDir, path);
            if (file.isDirectory()) {
                FileUtils.createDir((File)storedFile);
                continue;
            }
            FileUtils.copyFile((File)file, (File)storedFile);
        }
        for (String path : change.getModifyPaths()) {
            file = new File(this.getLocalViewDir(), path);
            storedFile = new File(changeStoreDir, path);
            FileUtils.copyFile((File)file, (File)storedFile);
        }
        return change;
    }

    private boolean isSuccessorVersion(String successor, String predecessor) {
        if (!StringUtils.substringBeforeLast((String)successor, (String)"/").equals(StringUtils.substringBeforeLast((String)predecessor, (String)"/"))) {
            return false;
        }
        String successorVersionOnBranch = StringUtils.substringAfterLast((String)successor, (String)"/");
        String predecessorVersionOnBranch = StringUtils.substringAfterLast((String)predecessor, (String)"/");
        if (!StringUtils.isNumeric((String)successorVersionOnBranch) || !StringUtils.isNumeric((String)predecessorVersionOnBranch)) {
            return false;
        }
        return Long.parseLong(successorVersionOnBranch) > Long.parseLong(predecessorVersionOnBranch);
    }

    @ScriptApi(value="Get repository object.")
    public abstract ClearCaseRepository getRepository();
}

