/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.DirectoryView;
import java.io.File;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;

public class ExternalArtifactOverviewPanel
extends Panel {
    public ExternalArtifactOverviewPanel(String panelId, final File artifactsDir) {
        super(panelId);
        this.add(new Component[]{new Link<Void>("download"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission((String)ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name()));
            }

            public void onClick() {
                final File tempFile = FileUtils.createTempFile((String)"dirdownload");
                try {
                    FileUtils.zip((File)artifactsDir, (File)tempFile);
                    FileResourceStream resourceStream = new FileResourceStream(new org.apache.wicket.util.file.File(tempFile));
                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, "artifacts.zip"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void respond(IRequestCycle requestCycle) {
                            try {
                                super.respond(requestCycle);
                            }
                            finally {
                                FileUtils.deleteFile((File)tempFile);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    FileUtils.deleteFile((File)tempFile);
                }
            }
        }});
        this.add(new Component[]{new DirectoryView("content", (IModel)Model.of((Serializable)artifactsDir), SecurityHelper.hasPermission((String)ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name()))});
    }
}

