/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.BuildBasedGadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.artifact.ArtifactPlugin;
import com.pmease.quickbuild.plugin.artifact.ExternalArtifactSetting;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.DirectoryView;
import java.io.File;
import java.io.Serializable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

@Editable(name="External Artifacts", category={"Artifacts and Html Reports"})
public class ExternalArtifactGadget
extends BuildBasedGadget {
    private static final long serialVersionUID = 1L;

    protected Panel renderBodyForBuild(String panelId) {
        if (SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_ARTIFACTS.name()) || Context.getBuild().isRecommended() && SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
            ExternalArtifactSetting artifactSetting = (ExternalArtifactSetting)PluginSettingHelper.findConfigurationSetting(ArtifactPlugin.class, (Configuration)Context.getConfiguration(), (boolean)true);
            if (artifactSetting != null) {
                File externalArtifactsDir = new File(artifactSetting.getExternalDirectory());
                if (externalArtifactsDir.exists()) {
                    return new DirectoryView(panelId, (IModel)Model.of((Serializable)externalArtifactsDir), SecurityHelper.hasPermission((String)ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name()));
                }
                throw new QuickbuildException("Can not find external artifacts directory: " + externalArtifactsDir.getAbsolutePath());
            }
            throw new QuickbuildException("External artifacts setting is not defined for configuration: " + Context.getConfiguration());
        }
        throw new AccessDeniedException("You do not have permission to access configuration '" + Context.getConfiguration() + "'.");
    }
}

