/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.ArtifactFile;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, order=30, name="Artifacts", description="Publish specified files to server as build artifacts. This step can run either from server side or from agent side.")
@ScriptApi(value="This step publish specified files as build artifacts.")
public class ArtifactPublishStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcPath;
    private String filePatterns = "**";
    private String destPath;

    @Editable(order=1000, name="Source Directory", description="Specify the directory from which the files will be published. A non-absolute path is considered to be relative to current workspace directory . If left empty, the workspace directory itself will be used.")
    @ScriptApi(value="Get source path under which files will be published as artifacts. Null will be returned if publish files under the workspace.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=1100, name="Files To Publish", description="Specify patterns of files that need to be published. Patterns will be matched under the <b>source directory</b> specified above. Matched files will be copied to the <b>destination path</b> specified below. The directory structure will be preserved during the copy.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @ScriptApi(value="Get patterns of files to be published as artifacts.")
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String fileNamePatterns) {
        this.filePatterns = fileNamePatterns;
    }

    @Editable(order=1300, name="Destination Directory", description="Specify a destination directory for this publishing. Specified path is considered to be relative to current build's artifacts directory. If left empty, the artifacts directory itself will be used.")
    @ScriptApi(value="Get destination path of published build artifacts. Null will be returned if publish to the <em>artifacts</em> directory itself.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Build build = Context.getBuild();
        File srcDir = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getSrcPath());
        if (!srcDir.exists()) {
            throw new QuickbuildException("Can not find source directory for artifact publishing: " + srcDir.getAbsolutePath());
        }
        String destPath = this.getDestPath() != null ? "artifacts/" + this.getDestPath() : "artifacts";
        ArtifactStorage artifactStorage = Context.getConfiguration().findArtifactStorage();
        if (artifactStorage instanceof ServerArtifactStorage) {
            artifactStorage.getBatchSupport().upload(srcDir, this.getFilePatterns(), build, destPath);
        } else {
            File tempDir = FileUtils.createTempDir((String)"artifactpublish");
            try {
                for (File file : FileUtils.listFiles((File)srcDir, (String)this.getFilePatterns())) {
                    if (!file.isFile()) continue;
                    String relativePath = FileUtils.getRelativePath((String)file.getAbsolutePath(), (String)srcDir.getAbsolutePath());
                    Preconditions.checkNotNull((Object)relativePath);
                    File artifactFile = new File(tempDir, relativePath);
                    FileUtils.createDir((File)artifactFile.getParentFile());
                    ArtifactFile.writeTo((File)artifactFile, (long)file.length());
                    if (artifactStorage.getBatchSupport() != null) continue;
                    artifactStorage.upload(artifactFile, build, destPath + relativePath);
                }
                build.publish(tempDir.getAbsolutePath(), "**", destPath);
                if (artifactStorage.getBatchSupport() != null) {
                    artifactStorage.getBatchSupport().upload(srcDir, this.getFilePatterns(), build, destPath);
                }
            }
            finally {
                FileUtils.deleteDir((File)tempDir);
            }
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (dom.getRootElement().element("publishAsLinks") == null) {
            dom.getRootElement().addElement("publishAsLinks").setText("false");
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("publishAsLinks").detach();
    }
}

