/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.ArtifactStorageProvider;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.plugin.artifact.AgentArtifactStorage;
import com.pmease.quickbuild.plugin.artifact.ArtifactCleanupTask;
import com.pmease.quickbuild.plugin.artifact.ArtifactGadget;
import com.pmease.quickbuild.plugin.artifact.ArtifactOverviewPanel;
import com.pmease.quickbuild.plugin.artifact.ArtifactPublishStep;
import com.pmease.quickbuild.plugin.artifact.ArtifactSummaryPanel;
import com.pmease.quickbuild.plugin.artifact.ExternalArtifactGadget;
import com.pmease.quickbuild.plugin.artifact.ExternalArtifactOverviewPanel;
import com.pmease.quickbuild.plugin.artifact.ExternalArtifactSetting;
import com.pmease.quickbuild.plugin.artifact.ExternalArtifactSummaryPanel;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.stepsupport.Step;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;

public class ArtifactPlugin
extends AbstractPlugin {
    private static final int order = 10;

    public Object[] getExtensions() {
        return new Object[]{new StepProvider(){

            public Class<? extends Step> getStepClass() {
                return ArtifactPublishStep.class;
            }
        }, new ArtifactStorageProvider(){

            public Class<? extends ArtifactStorage> getArtifactStorageClass() {
                return ServerArtifactStorage.class;
            }
        }, new ArtifactStorageProvider(){

            public Class<? extends ArtifactStorage> getArtifactStorageClass() {
                return AgentArtifactStorage.class;
            }
        }, new ArtifactCleanupTask(), new BuildOverviewContribution(){

            public int getOrder() {
                return 10;
            }

            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> providers = new ArrayList<PanelCreator>();
                if (SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_ARTIFACTS.name()) || Context.getBuild().isRecommended() && SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
                    File externalArtifactsDir;
                    ExternalArtifactSetting artifactSetting;
                    if (Context.getBuild().getArtifactsDir().exists()) {
                        providers.add(new PanelCreator(){

                            public Panel newPanel(String panelId) {
                                return new ArtifactOverviewPanel(panelId);
                            }
                        });
                    }
                    if ((artifactSetting = (ExternalArtifactSetting)ArtifactPlugin.this.findConfigurationSetting(Context.getConfiguration(), true)) != null && (externalArtifactsDir = new File(artifactSetting.getExternalDirectory())).exists()) {
                        providers.add(new PanelCreator(){

                            public Panel newPanel(String id) {
                                return new ExternalArtifactOverviewPanel(id, externalArtifactsDir);
                            }
                        });
                    }
                }
                return providers;
            }
        }, new BuildSummaryContribution(){

            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> providers = new ArrayList<PanelCreator>();
                if (SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_ARTIFACTS.name()) || Context.getBuild().isRecommended() && SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
                    File externalArtifactsDir;
                    ExternalArtifactSetting artifactSetting;
                    if (Context.getBuild().getArtifactsDir().exists()) {
                        providers.add(new PanelCreator(){

                            public Panel newPanel(String panelId) {
                                return new ArtifactSummaryPanel(panelId);
                            }
                        });
                    }
                    if ((artifactSetting = (ExternalArtifactSetting)ArtifactPlugin.this.findConfigurationSetting(Context.getConfiguration(), true)) != null && (externalArtifactsDir = new File(artifactSetting.getExternalDirectory())).exists()) {
                        providers.add(new PanelCreator(){

                            public Panel newPanel(String id) {
                                return new ExternalArtifactSummaryPanel(id, externalArtifactsDir);
                            }
                        });
                    }
                }
                return providers;
            }

            public int getOrder() {
                return 10;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return ArtifactGadget.class;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return ExternalArtifactGadget.class;
            }
        }};
    }

    public Class<?> getConfigurationSettingClass() {
        return ExternalArtifactSetting.class;
    }

    public PluginCategory getCategory() {
        return PluginCategory.SYSTEM;
    }
}

