/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.ArtifactFile;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.treetable.TreeDataProvider;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;

public class ArtifactPanel
extends Panel {
    private Set<ArtifactFile> expandedPaths = new HashSet<ArtifactFile>();

    public ArtifactPanel(String panelId) {
        super(panelId);
        this.add(new Component[]{new TreeTable("treeTable", new TreeDataProvider(){

            public List<Serializable> getChildNodeKeys(Serializable nodeKey) {
                ArrayList<Serializable> childNodeKeys = new ArrayList<Serializable>();
                File parent = (File)nodeKey;
                if (parent.isDirectory()) {
                    File[] folders = parent.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    if (folders != null) {
                        Arrays.sort(folders, new Comparator<File>(){

                            @Override
                            public int compare(File file1, File file2) {
                                return file1.getName().compareTo(file2.getName());
                            }
                        });
                        for (File each : folders) {
                            childNodeKeys.add((Serializable)new ArtifactFile(each));
                        }
                    }
                    ArrayList<ArtifactFile> files = new ArrayList<ArtifactFile>();
                    File[] children = parent.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile();
                        }
                    });
                    if (children != null) {
                        for (File each : children) {
                            files.add(new ArtifactFile(each));
                        }
                    }
                    Collections.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File file1, File file2) {
                            return file1.getName().compareTo(file2.getName());
                        }
                    });
                    for (ArtifactFile each : files) {
                        childNodeKeys.add((Serializable)each);
                    }
                }
                return childNodeKeys;
            }

            public Serializable getParentNodeKey(Serializable nodeKey) {
                File parent = ((ArtifactFile)nodeKey).getParentFile();
                return parent.equals(Context.getBuild().getArtifactsDir()) ? null : parent;
            }

            public List<Serializable> getRootNodeKeys() {
                return this.getChildNodeKeys(Context.getBuild().getArtifactsDir());
            }

            public boolean isExpandable(Serializable nodeKey) {
                return ((ArtifactFile)nodeKey).isDirectory();
            }
        }, new TreeState(){

            public boolean isExpanded(Serializable nodeKey) {
                return ArtifactPanel.this.expandedPaths.contains(nodeKey);
            }

            public void setExpanded(Serializable nodeKey, boolean expanded) {
                if (expanded) {
                    ArtifactPanel.this.expandedPaths.add((ArtifactFile)nodeKey);
                } else {
                    ArtifactPanel.this.expandedPaths.remove(nodeKey);
                }
            }
        }, new TreeTableColumn(){

            public Component newCell(String id, Serializable nodeKey) {
                Fragment fragment = new Fragment(id, "nodeFrag", (MarkupContainer)ArtifactPanel.this);
                final ArtifactFile file = (ArtifactFile)nodeKey;
                if (file.isDirectory()) {
                    if (ArtifactPanel.this.expandedPaths.contains(file.getAbsolutePath())) {
                        fragment.add(new Component[]{new InternalImage("icon", "/images/folder-open.gif")});
                    } else {
                        fragment.add(new Component[]{new InternalImage("icon", "/images/folder.gif")});
                    }
                } else {
                    fragment.add(new Component[]{new InternalImage("icon", "/images/file.gif")});
                }
                WebMarkupContainer link = new WebMarkupContainer("link"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        String relativePath = FileUtils.getRelativePath((String)file.getAbsolutePath(), (String)Context.getBuild().getPublishDir().getAbsolutePath()).substring(1);
                        Validate.isTrue((boolean)StringUtils.isNotBlank((String)relativePath));
                        if (file.isDirectory()) {
                            if (Context.getConfiguration().findArtifactStorage().getBatchSupport() != null && SecurityHelper.hasPermission((Configuration)Context.getConfiguration(), (String)ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name())) {
                                tag.put("href", (CharSequence)Context.getConfiguration().findArtifactStorage().getBatchSupport().getUrl(Context.getBuild(), relativePath, "**"));
                                tag.put("title", (CharSequence)"Download all files recursively under this directory");
                            } else {
                                tag.put("href", (CharSequence)"javascript:void(0);");
                                tag.put("class", (CharSequence)"not-link");
                            }
                        } else {
                            tag.put("href", (CharSequence)Context.getConfiguration().findArtifactStorage().getUrl(Context.getBuild(), relativePath));
                            tag.put("title", (CharSequence)"Download this file");
                        }
                    }
                };
                if (file.isDirectory() && Context.getConfiguration().findArtifactStorage().getBatchSupport() != null && SecurityHelper.hasPermission((Configuration)Context.getConfiguration(), (String)ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name())) {
                    link.add(new Behavior[]{new ConfirmBehavior("This will download all files recursively under this directory, and may take a considerable time if there are many files. Do you really want to continue?")});
                }
                link.add(new Component[]{new Label("name", file.getName())});
                fragment.add(new Component[]{link});
                return fragment;
            }

            public Component newHeader(String id) {
                return ArtifactPanel.this.newTreeHeader(id);
            }
        }, new TreeTableColumn[]{new TreeTableColumn(){

            public Component newCell(String id, Serializable nodeKey) {
                File file = (File)nodeKey;
                if (file.isFile()) {
                    return new Label(id, FileUtils.byteCountToDisplaySize((long)file.length()));
                }
                return new Label(id, " ");
            }

            public Component newHeader(String id) {
                Label header = new Label(id, "Size");
                header.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight:bold;"))});
                return header;
            }
        }, new TreeTableColumn(){

            public Component newCell(String id, Serializable nodeKey) {
                return new Label(id, DateUtils.formatDateTime((Date)new Date(((File)nodeKey).lastModified())));
            }

            public Component newHeader(String id) {
                Label header = new Label(id, "Last Modified");
                header.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight:bold;"))});
                return header;
            }
        }}, false)});
    }

    protected Component newTreeHeader(String id) {
        Label header = new Label(id, "Name");
        header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"bold"))});
        return header;
    }
}

