/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.MaintenanceTask;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.setting.configuration.artifactcleanup.ArtifactCleanupStrategy;
import com.pmease.quickbuild.setting.configuration.artifactcleanup.ReserveArtifactsByBuilds;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCleanupTask
implements MaintenanceTask {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactCleanupTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        for (Long configurationId : CacheManager.instance.getConfigurations().keySet()) {
            Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
            Context.push((Configuration)configuration);
            try {
                ArtifactCleanupStrategy strategy = configuration.findArtifactCleanupStrategy();
                strategy = (ArtifactCleanupStrategy)ScriptEngine.instance.installInterpolator((Object)strategy);
                if (strategy.getCount() != 0) {
                    List builds;
                    logger.info("Cleaning up artifacts for configuration '{}'...", (Object)configuration.getPathName());
                    File configurationArtifactsDir = new File(configuration.getPublishDir(), "artifacts");
                    File lastCleanupBuildFile = new File(configurationArtifactsDir, "last_cleanup_build");
                    long lastCleanupId = 0L;
                    if (lastCleanupBuildFile.exists()) {
                        try {
                            lastCleanupId = Long.parseLong(FileUtils.readFileAsString((File)lastCleanupBuildFile));
                            Build latestBuild = CacheManager.instance.getLatestBuild(configuration.getId());
                            if (latestBuild != null && latestBuild.getId() < lastCleanupId) {
                                lastCleanupId = 0L;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Error reading last cleanup file, will use 0 as last cleanup build id.", (Throwable)e);
                        }
                    }
                    ArtifactStorage artifactStorage = configuration.findArtifactStorage();
                    if (strategy instanceof ReserveArtifactsByBuilds) {
                        try {
                            Session session = SessionManager.openSession();
                            Query query = session.createQuery("from Build where configuration=:configuration and id>:lastCleanupId order by id");
                            query.setParameter("configuration", (Object)configuration);
                            query.setParameter("lastCleanupId", (Object)lastCleanupId);
                            builds = query.list();
                        }
                        finally {
                            SessionManager.closeSession();
                        }
                        int size = builds.size();
                        int index = 0;
                        for (Build build : builds) {
                            if (index < size - strategy.getCount()) {
                                Context.getLogger().info("Removing artifacts of build '{}'...", (Object)build.getVersion());
                                artifactStorage.cleanupArtifacts(build, "artifacts");
                                lastCleanupId = build.getId();
                            }
                            ++index;
                        }
                    } else {
                        try {
                            Session session = SessionManager.openSession();
                            Query query = session.createQuery("from Build where configuration=:configuration and beginDate<:date and id>:lastCleanupId order by id");
                            query.setParameter("configuration", (Object)configuration);
                            long reserveMillis = 86400000L * (long)strategy.getCount();
                            query.setParameter("date", (Object)new Date(System.currentTimeMillis() - reserveMillis));
                            query.setParameter("lastCleanupId", (Object)lastCleanupId);
                            builds = query.list();
                        }
                        finally {
                            SessionManager.closeSession();
                        }
                        for (Build build : builds) {
                            Context.getLogger().info("Removing artifacts of build '{}'...", (Object)build.getVersion());
                            artifactStorage.cleanupArtifacts(build, "artifacts");
                            lastCleanupId = build.getId();
                        }
                    }
                    FileUtils.writeFile((File)lastCleanupBuildFile, (String)String.valueOf(lastCleanupId));
                }
                Thread.yield();
            }
            catch (Exception e) {
                logger.error("Error cleaning up artifacts of configuration '" + configuration.getPathName() + "'.", (Throwable)e);
            }
            finally {
                Context.pop();
            }
        }
    }
}

