/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.artifact;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;

@Editable(name="Store artifacts on specified agent", order=200)
public class AgentArtifactStorage
extends ArtifactStorage {
    private static final long serialVersionUID = 1L;
    public static final int TOKEN_VALID_MINUTES = 30;
    private String agentAddress;

    @Editable(description="Choose an agent to store and serve artifacts for this configuration. By default, artifacts will be stored on agent in directory &lt;QuickBuild agent install dir&gt;/storage, with directory stucture conforming to storage directory setting specified above. If the storage directory evaluates to an absolute path, you should make sure that that absolute directory exists on agent.")
    @ChoiceProvider(value="getAgentAddresses")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get agent address.")
    public String getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(String agentAddress) {
        this.agentAddress = agentAddress;
    }

    private static List<String> getAgentAddresses() {
        ArrayList<String> agentAddresses = new ArrayList<String>();
        for (GridNode node : AgentManager.instance.getBuildAgents()) {
            agentAddresses.add(node.getAddress());
        }
        return agentAddresses;
    }

    private GridNode getAgent() {
        GridNode agent = Grid.instance.getNode(this.getAgentAddress());
        if (agent == null) {
            throw new QuickbuildException("Unable to find build agent: " + this.getAgentAddress());
        }
        return agent;
    }

    public void download(Build build, String artifactFile, File destFile) {
        GridNode agent = this.getAgent();
        String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
        Grid.instance.transferFile(agent, buildPublishDir + "/" + artifactFile, Grid.instance.getLocalNode(), destFile.getAbsolutePath(), null, null);
    }

    public void upload(File srcFile, Build build, String artifactFile) {
        GridNode agent = this.getAgent();
        String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
        Grid.instance.transferFile(Grid.instance.getLocalNode(), srcFile.getAbsolutePath(), agent, buildPublishDir + "/" + artifactFile, null, null);
    }

    public String getUrl(Build build, String artifactFile) {
        String url = this.getAgent().getUrl() + "/download" + "/" + build.getLatestAwareId() + "/" + artifactFile;
        if (Context.getUser() != null) {
            Date validUntil = new DateTime().plusMinutes(30).toDate();
            String token = SecurityHelper.generateAccessToken((User)Context.getUser(), (Date)validUntil);
            try {
                String encodedToken = URLEncoder.encode(token, "UTF-8");
                url = url + "?token=" + encodedToken;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public void cleanup(Build build, String artifactFile) {
        GridNode agent = this.getAgent();
        String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
        agent.deleteFile(buildPublishDir + "/" + artifactFile);
    }

    public ArtifactStorage.BatchSupport getBatchSupport() {
        return new ArtifactStorage.BatchSupport(){

            public String getUrl(Build build, String artifactDir, String artifactPatterns) {
                try {
                    String url = AgentArtifactStorage.this.getAgent().getUrl() + "/batch_download" + "?" + "build_id" + "=" + build.getLatestAwareId() + "&" + "src_path" + "=" + URLEncoder.encode(artifactDir, "UTF-8") + "&" + "file_patterns" + "=" + URLEncoder.encode(artifactPatterns, "UTF-8");
                    if (Context.getUser() != null) {
                        Date validUntil = new DateTime().plusMinutes(30).toDate();
                        String token = SecurityHelper.generateAccessToken((User)Context.getUser(), (Date)validUntil);
                        url = url + "&token=" + URLEncoder.encode(token, "UTF-8");
                    }
                    return url;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void download(Build build, String artifactDir, String artifactPatterns, File destDir) {
                GridNode agent = AgentArtifactStorage.this.getAgent();
                String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
                Grid.instance.transferFiles(agent, buildPublishDir + "/" + artifactDir, artifactPatterns, Grid.instance.getLocalNode(), destDir.getAbsolutePath(), false, null, null);
            }

            public void upload(File srcDir, String srcPatterns, Build build, String artifactDir) {
                GridNode agent = AgentArtifactStorage.this.getAgent();
                String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
                Grid.instance.transferFiles(Grid.instance.getLocalNode(), srcDir.getAbsolutePath(), srcPatterns, agent, buildPublishDir + "/" + artifactDir, false, null, null);
            }

            public void cleanup(Build build, String artifactDir) {
                GridNode agent = AgentArtifactStorage.this.getAgent();
                String buildPublishDir = agent.getNodeService().getBuildPublishDir(build.getId());
                if (artifactDir != null) {
                    agent.deleteDir(buildPublishDir + "/" + artifactDir);
                } else {
                    agent.deleteDir(buildPublishDir);
                }
            }
        };
    }
}

