/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.test;

import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class DbTest {
    final ExecutorService writes;
    final ExecutorService reads;
    boolean shutdown = false;
    boolean paused = false;
    File dir = new File("/Users/zhenyu/tmp/changes");
    public static DbTest instance = new DbTest();
    AtomicLong buildId = new AtomicLong(1L);

    public DbTest() {
        this.writes = Executors.newFixedThreadPool(3);
        this.reads = Executors.newFixedThreadPool(5);
    }

    public void start() {
        int i;
        this.shutdown = false;
        for (i = 0; i < 3; ++i) {
            this.writes.execute(new WriteJob());
            this.reads.execute(new ReadJob());
        }
        for (i = 0; i < 2; ++i) {
            this.reads.execute(new ReadJob());
        }
    }

    public void stop() {
        this.shutdown = true;
        this.writes.shutdown();
        this.reads.shutdown();
    }

    public void pause() {
        this.paused = !this.paused;
    }

    private class ReadJob
    implements Runnable {
        private ReadJob() {
        }

        @Override
        public void run() {
            ReportCategory category = ReportHelper.getCategory(ChangesPlugin.class);
            while (!DbTest.this.shutdown) {
                while (DbTest.this.paused) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                DataReport report = category.loadReport(DbTest.this.dir, "stats", new Filter[0]);
                System.out.println("Rows: " + report.getRowsCount());
                category.loadReport(DbTest.this.dir, "modifications", new Filter[0]);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    private class WriteJob
    implements Runnable {
        private WriteJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReportCategory category = ReportHelper.getCategory(ChangesPlugin.class);
            while (!DbTest.this.shutdown) {
                while (DbTest.this.paused) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                DataReport stats = category.createReport("stats");
                DataRow row = stats.addRow();
                long build = DbTest.this.buildId.incrementAndGet();
                row.setValue("buildId", (Object)build);
                row.setValue("files", (Object)10);
                row.setValue("commits", (Object)20);
                row.setValue("modifications", (Object)60);
                row.setValue("added", (Object)20);
                row.setValue("modified", (Object)30);
                row.setValue("deleted", (Object)10);
                CategoryDb statsDb = category.getCategoryDb(DbTest.this.dir);
                statsDb.open(DbStore.Mode.READ_WRITE, "DbTest");
                try {
                    statsDb.update("DELETE FROM modifications WHERE buildId=" + build);
                    statsDb.update("DELETE FROM changesets WHERE buildId=" + build);
                    statsDb.update("DELETE FROM stats WHERE buildId=" + build);
                    category.saveReport(statsDb, stats);
                    System.out.println("Build [" + build + "] stats saved");
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                finally {
                    statsDb.close();
                }
            }
        }
    }
}

