/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.rest;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;

@XStreamAlias(value="changeset")
public class RawChangeset
extends Changeset {
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private String repositoryType;
    private String additional;
    private Long buildId;

    public RawChangeset(String repository) {
        this.repositoryName = repository;
    }

    public RawChangeset(RawChangeset other) {
        this(other.repositoryName);
        this.repositoryType = other.repositoryType;
        this.additional = other.additional;
        this.setComment(other.getComment());
        this.setDate(other.getDate());
        this.setUser(other.getUser());
        this.setId(other.getId());
        this.setModifications(new ArrayList(other.getModifications()));
        this.setClosedTasks(new HashSet(other.getClosedTasks()));
    }

    public RawChangeset(String repository, DataRow row) {
        this.repositoryName = repository;
        this.buildFromRow(row);
    }

    protected void buildFromRow(DataRow row) {
        this.setId(row.getValueAsString("changeId"));
        this.setComment(row.getValueAsString("comment"));
        this.setAdditional(row.getValueAsString("additional"));
        Calendar cal = (Calendar)row.getValue("commitDate");
        if (cal != null) {
            this.setDate(cal.getTime());
        }
        this.setUser(row.getValueAsString("committer"));
        this.setBuildId(row.getLong("buildId"));
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public Long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(Long buildId) {
        this.buildId = buildId;
    }
}

