/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.changes.rest.RawModification;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class ChangesetMapper
implements ResultSetHandler<List<RawChangeset>> {
    private final List<RawChangeset> changesets = Lists.newArrayList();
    private final Map<String, Repository<?>> repositories;

    public ChangesetMapper(Map<String, Repository<?>> repositories) {
        this.repositories = repositories;
    }

    public List<RawChangeset> handle(ResultSet rs) throws SQLException {
        HashMap indexes = Maps.newHashMap();
        while (rs.next()) {
            String previous;
            String fileName;
            RawChangeset change;
            Long buildId = rs.getLong("changesets.buildId");
            String repoName = rs.getString("changesets.repository");
            String changeId = rs.getString("changesets.changeId");
            String key = buildId + ":" + repoName + ":" + changeId;
            if (indexes.containsKey(key)) {
                change = this.changesets.get((Integer)indexes.get(key));
            } else {
                change = new RawChangeset(repoName);
                change.setBuildId(buildId);
                change.setId(changeId);
                change.setAdditional(rs.getString("changesets.additional"));
                change.setComment(rs.getString("changesets.comment"));
                Timestamp ts = rs.getTimestamp("changesets.commitDate");
                if (ts != null) {
                    change.setDate(new Date(ts.getTime()));
                }
                change.setUser(rs.getString("changesets.committer"));
                if (this.repositories.containsKey(repoName)) {
                    change.setRepositoryType(this.repositories.get(repoName).getType());
                }
                indexes.put(key, this.changesets.size());
                this.changesets.add(change);
            }
            if (Strings.isNullOrEmpty((String)(fileName = rs.getString("modifications.fileName")))) continue;
            RawModification m = new RawModification();
            String action = rs.getString("modifications.action");
            if (!Strings.isNullOrEmpty((String)action)) {
                m.setAction(Modification.Action.valueOf((String)action));
            }
            m.setAdditional(change.getAdditional());
            m.setEdition(rs.getString("modifications.edition"));
            m.setPath(fileName);
            String pathType = rs.getString("modifications.pathType");
            if (!Strings.isNullOrEmpty((String)pathType)) {
                m.setPathType(Modification.PathType.valueOf((String)pathType));
            }
            if (!Strings.isNullOrEmpty((String)(previous = rs.getString("modifications.previousEdition")))) {
                m.setPreviousEdition(previous);
            }
            change.getModifications().add(m);
        }
        return this.changesets;
    }
}

