/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesCategory;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.changes.rest.ChangeStats;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.rest.BaseReportRest;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamType;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamsHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestHelp;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateUtils;
import org.h2.util.StringUtils;
import org.joda.time.DateTime;

@Path(value="/changes")
public class ChangesResource
extends BaseReportRest {
    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(ChangesPlugin.class);
    }

    protected void checkPermission(Configuration c) {
        if (!SecurityHelper.hasPermission((Configuration)c, (String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            throw new AccessDeniedException("You have no 'ACCESS_BUILD_CHANGES' permission to access configuration: " + c.getPathName());
        }
    }

    static List<Filter> buildFilters(Configuration configuration, Long fromBuild, Long toBuild, String fromDate, String toDate, String datePattern, String repository, String committer) {
        ArrayList filters = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)repository)) {
            filters.add(Restrictions.eq((String)"changesets.repository", (Object)repository));
        }
        if (!Strings.isNullOrEmpty((String)committer)) {
            filters.add(Restrictions.eq((String)"changesets.committer", (Object)committer));
        }
        if (fromBuild != null) {
            if (toBuild == null) {
                toBuild = configuration.getLatestFinishedBuild().getId();
            }
            filters.add(Restrictions.ge((String)"changesets.buildId", (Object)fromBuild));
            filters.add(Restrictions.le((String)"changesets.buildId", (Object)toBuild));
            return filters;
        }
        if (!Strings.isNullOrEmpty((String)fromDate)) {
            Date to;
            String pattern = Strings.isNullOrEmpty((String)datePattern) ? "yyyyMMdd" : datePattern;
            Date from = (Date)DataTypes.DATE.fromString(fromDate, pattern);
            if (StringUtils.isNullOrEmpty((String)toDate)) {
                to = new Date();
            } else {
                to = (Date)DataTypes.DATE.fromString(toDate, pattern);
                DateTime dt = new DateTime((Object)to);
                if (dt.getHourOfDay() == 0 && dt.getMinuteOfHour() == 0 && dt.getSecondOfMinute() == 0) {
                    to = DateUtils.addDays((Date)to, (int)1);
                }
            }
            filters.add(Restrictions.ge((String)"changesets.commitDate", (Object)from));
            filters.add(Restrictions.lt((String)"changesets.commitDate", (Object)to));
        }
        return filters;
    }

    @Path(value="/stats/build/{buildId}")
    @GET
    @RestHelp(value="Get the commit stats for a specified build")
    @ParamsHelp(value={@ParamHelp(name="buildId", type=ParamType.PATH_PARAM, required=true, description="Specify the build id which you want to retrieve the commit stats")})
    public ChangeStats getBuildStats(@PathParam(value="buildId") Long buildId) {
        ReportCategory category = this.getCategory();
        Build build = this.getBuild(buildId);
        File dir = category.getReportDirOfBuild(build, "DEFAULT");
        ChangeStats stats = new ChangeStats();
        if (!dir.exists()) {
            return stats;
        }
        DataReport report = category.loadReport(dir, this.getBuildStatsReportName(), new Filter[0]);
        if (report.isEmpty()) {
            return stats;
        }
        DataRow row = report.getRow(0);
        stats.setAdded(row.getInt("added"));
        stats.setCommits(row.getInt("commits"));
        stats.setDeleted(row.getInt("deleted"));
        stats.setModifications(row.getInt("modifications"));
        stats.setModified(row.getInt("modified"));
        return stats;
    }

    @Path(value="/commits/build/{buildId}")
    @GET
    @RestHelp(value="Get all modifications of a specified build")
    @ParamsHelp(value={@ParamHelp(name="buildId", type=ParamType.PATH_PARAM, required=true, description="Specify the build id which you want to retrieve the modifications"), @ParamHelp(name="offset", description="Specify the first record when iterate the records. By default, the offset is 0."), @ParamHelp(name="limit", description="Specify the number of total records you want to retrieve. If not specified, all records returned"), @ParamHelp(name="repository", description="Get the changes only in a specific repository."), @ParamHelp(name="committer", description="Get the changes only committed by the specified committer"), @ParamHelp(name="asc", description="Boolean type, specify the order by commit date ascendent or descendent. By default, the result is descendent.")})
    public List<RawChangeset> getBuildChanges(@PathParam(value="buildId") Long buildId, @QueryParam(value="repository") String repository, @QueryParam(value="committer") String committer, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="asc") Boolean asc) {
        Build build;
        ChangesCategory category = (ChangesCategory)this.getCategory();
        File dir = category.getChangesDirOfBuild(build = this.getBuild(buildId));
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        if (asc == null) {
            asc = false;
        }
        List<Filter> filters = ChangesResource.buildFilters(build.getConfiguration(), null, null, null, null, null, repository, committer);
        return ChangesHelper.getBuildChangesets(build, filters, offset, Integer.MAX_VALUE, asc);
    }

    @Path(value="/stats/{configuration: .*}")
    @GET
    @RestHelp(value="Get the commit stats of a specified configuration.")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="build", description="Specify the build id you want."), @ParamHelp(name="from_build", description="Specify the from build (including the specified build) when finding changes in a build range."), @ParamHelp(name="to_build", description="Specify the to build (including the specified build) when finding changes in a build range. "), @ParamHelp(name="from_date", description="Specify the from date (including the specified date) when finding changes in a build range"), @ParamHelp(name="to_date", description="Specify the to date (excluding the specified date) when finding changes in a build range"), @ParamHelp(name="date_pattern", description="Specify the date pattern when query by a date range, by default, the pattern is yyyyMMdd."), @ParamHelp(name="repository", description="Get the changes only in a specific repository."), @ParamHelp(name="committer", description="Get the changes only committed by the specified committer")})
    public ChangeStats getStats(@PathParam(value="configuration") String cstr, @QueryParam(value="build") Long buildId, @QueryParam(value="from_build") Long fromBuild, @QueryParam(value="to_build") Long toBuild, @QueryParam(value="from_date") String fromDate, @QueryParam(value="to_date") String toDate, @QueryParam(value="date_pattern") String datePattern, @QueryParam(value="repository") String repository, @QueryParam(value="committer") String committer) {
        Configuration c = this.getConfiguration(cstr);
        ReportCategory category = this.getCategory();
        File dbDir = category.getReportDirOfStats(c, "DEFAULT");
        if (!dbDir.exists()) {
            return new ChangeStats();
        }
        List<Filter> filters = buildId == null ? ChangesResource.buildFilters(c, fromBuild, toBuild, fromDate, toDate, datePattern, repository, committer) : ChangesResource.buildFilters(c, buildId, buildId, fromDate, toDate, datePattern, repository, committer);
        Map map = category.getDefaultStats(dbDir, "changesets", (Filter[])Iterables.toArray(filters, Filter.class));
        ChangeStats stats = new ChangeStats();
        stats.setCommits(MapUtils.getInteger((Map)map, (Object)"totals", (Integer)0));
        stats.setModifications(MapUtils.getInteger((Map)map, (Object)"modifications", (Integer)0));
        stats.setAdded(MapUtils.getInteger((Map)map, (Object)"added", (Integer)0));
        stats.setModified(MapUtils.getInteger((Map)map, (Object)"modified", (Integer)0));
        stats.setDeleted(MapUtils.getInteger((Map)map, (Object)"deleted", (Integer)0));
        return stats;
    }

    @Path(value="/{configuration: .*}")
    @GET
    @RestHelp(value="Retrieve modifications for a specific configuration.")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="build", type=ParamType.QUERY_PARAM, description="Specify the build id you want."), @ParamHelp(name="from_build", description="Specify the from build (including the specified build) when finding changes in a build range."), @ParamHelp(name="to_build", description="Specify the to build (excluding the specified build) when finding changes in a build range. "), @ParamHelp(name="date_pattern", description="Specify the date pattern when query by a date range, by default, the pattern is yyyyMMdd."), @ParamHelp(name="from_date", description="Specify the from date (including the specified date) when finding changes in a build range."), @ParamHelp(name="to_date", description="Specify the to date (excluding the specified date) when finding changes in a build range."), @ParamHelp(name="change_id", description="Specify the change id you want to find."), @ParamHelp(name="repository", description="Get the changes only in a specific repository."), @ParamHelp(name="committer", description="Get the changes only committed by the specified committer."), @ParamHelp(name="offset", description="Specify the first record when iterate the records. By default, the offset is 0."), @ParamHelp(name="limit", description="Specify the number of total records you want to retrieve. By default, the number is 50."), @ParamHelp(name="asc", description="Boolean type, specify the order by commit date ascendent or descendent.")})
    public List<RawChangeset> getCommits(@PathParam(value="configuration") String cstr, @QueryParam(value="build") Long buildId, @QueryParam(value="from_build") Long fromBuild, @QueryParam(value="to_build") Long toBuild, @QueryParam(value="date_pattern") String datePattern, @QueryParam(value="from_date") String fromDate, @QueryParam(value="to_date") String toDate, @QueryParam(value="change_id") String changeId, @QueryParam(value="repository") String repository, @QueryParam(value="committer") String committer, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="asc") Boolean asc) {
        Configuration c = this.getConfiguration(cstr);
        List<Filter> filters = buildId != null ? ChangesResource.buildFilters(c, buildId, buildId, fromDate, toDate, datePattern, repository, committer) : ChangesResource.buildFilters(c, fromBuild, toBuild, fromDate, toDate, datePattern, repository, committer);
        if (!Strings.isNullOrEmpty((String)changeId)) {
            filters.add((Filter)Restrictions.eq((String)"changesets.changeId", (Object)changeId));
        }
        if (asc == null) {
            asc = false;
        }
        return ChangesHelper.getChangesets(c, filters, offset, limit, asc);
    }

    @Path(value="/size/{configuration: .*}")
    @GET
    @RestHelp(value="Retrieve the count/size of total changes")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="build", type=ParamType.QUERY_PARAM, description="Specify the build id you want."), @ParamHelp(name="from_build", description="Specify the from build when finding changes in a build range."), @ParamHelp(name="to_build", description="Specify the to build when finding changes in a build range. "), @ParamHelp(name="date_pattern", description="Specify the date pattern when query by a date range, by default, the pattern is yyyyMMdd."), @ParamHelp(name="from_date", description="Specify the from date when finding changes in a build range."), @ParamHelp(name="to_date", description="Specify the to date when finding changes in a build range."), @ParamHelp(name="change_id", description="Specify the change id you want to find."), @ParamHelp(name="repository", description="Get the changes only in a specific repository."), @ParamHelp(name="committer", description="Get the changes only committed by the specified committer.")})
    public long getSize(@PathParam(value="configuration") String cstr, @QueryParam(value="build") Long buildId, @QueryParam(value="from_build") Long fromBuild, @QueryParam(value="to_build") Long toBuild, @QueryParam(value="date_pattern") String datePattern, @QueryParam(value="from_date") String fromDate, @QueryParam(value="to_date") String toDate, @QueryParam(value="change_id") String changeId, @QueryParam(value="repository") String repository, @QueryParam(value="committer") String committer) {
        Configuration c = this.getConfiguration(cstr);
        List<Filter> filters = buildId != null ? ChangesResource.buildFilters(c, buildId, buildId, fromDate, toDate, datePattern, repository, committer) : ChangesResource.buildFilters(c, fromBuild, toBuild, fromDate, toDate, datePattern, repository, committer);
        if (!Strings.isNullOrEmpty((String)changeId)) {
            filters.add((Filter)Restrictions.eq((String)"changesets.changeId", (Object)changeId));
        }
        ReportCategory category = ReportHelper.getCategory(ChangesPlugin.class);
        File dbDir = category.getReportDirOfStats(c, "DEFAULT");
        return category.getRowsCount(dbDir, "changesets", filters);
    }

    public List<String> getReportNames() {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getMeta(@PathParam(value="name") String name) {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }

    public List<String> getReportSets(@PathParam(value="report_group") ReportGroup group, @PathParam(value="configuration_or_build_id") Long id) {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }

    public Long size(@PathParam(value="name") String name, @PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @Context UriInfo ui) {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getReportRecords(@PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @PathParam(value="name") String name, @Context UriInfo ui) {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getBuildStats(@PathParam(value="build_id") Long buildId, @PathParam(value="reportset") String reportset) {
        throw ChangesResource.buildException((int)405, (String)"The function is not available.");
    }
}

