/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.history;

import com.pmease.quickbuild.plugin.report.changes.renderer.history.DefaultHistoryPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class DateRangeFormPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final DefaultHistoryPanel parentPanel;

    public DateRangeFormPanel(String id, DefaultHistoryPanel parentPanel) {
        super(id);
        this.setOutputMarkupId(true);
        this.parentPanel = parentPanel;
        this.add(new Component[]{new DateRangeForm("dateRangeForm")});
    }

    private class DateRangeForm
    extends Form {
        private static final long serialVersionUID = 1L;
        private String feedbackMsg;
        private DateRange primaryDateRange;

        public DateRangeForm(String id) {
            super(id);
            this.primaryDateRange = SessionData.get().getLineChartOption().getPrimaryDateRange();
            final EditContext primaryRangeContext = new EditContext((Object)this.primaryDateRange);
            this.add(new Component[]{new PropertyEditor("primaryFromDate", primaryRangeContext.getBeanClass(), primaryRangeContext.getProperty("beginDate"))});
            this.add(new Component[]{new PropertyEditor("primaryToDate", primaryRangeContext.getBeanClass(), primaryRangeContext.getProperty("endDate"))});
            final Label feedback = new Label("feedback", (IModel)new AbstractReadOnlyModel<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return DateRangeForm.this.feedbackMsg;
                }
            }){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (!StringUtils.isBlank((String)DateRangeForm.this.feedbackMsg)) {
                        tag.put("style", (CharSequence)"");
                    } else {
                        tag.put("style", (CharSequence)"display:none;");
                    }
                }
            };
            feedback.setEscapeModelStrings(false);
            this.add(new Component[]{feedback.setOutputMarkupId(true)});
            AjaxButton submit = new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form form) {
                    primaryRangeContext.validate(false);
                    if (primaryRangeContext.hasError()) {
                        DateRangeForm.this.feedbackMsg = primaryRangeContext.getError();
                        target.add(new Component[]{feedback});
                        return;
                    }
                    primaryRangeContext.update((Object)DateRangeForm.this.primaryDateRange);
                    DateRangeForm.this.feedbackMsg = DateRangeForm.this.validateDate(DateRangeForm.this.primaryDateRange);
                    target.add(new Component[]{feedback});
                    if (StringUtils.isBlank((String)DateRangeForm.this.feedbackMsg)) {
                        SessionData.get().getLineChartOption().setPrimaryDateRange(DateRangeForm.this.primaryDateRange);
                        target.appendJavaScript((CharSequence)"$('.date_range_options').hide(); $('#date_range_selector').removeClass('current');");
                        this.send((IEventSink)DateRangeFormPanel.this.parentPanel, Broadcast.BREADTH, new DateRangeChanged(target, DateRangeForm.this.primaryDateRange));
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            };
            this.add(new Component[]{submit});
        }

        private String validateDate(DateRange primaryRange) {
            String result;
            StringBuilder msg = new StringBuilder();
            String error = this.validateDateRange(primaryRange);
            if (error != null) {
                msg.append("<li>" + error + "</li>");
            }
            if (StringUtils.isEmpty((String)(result = msg.toString()))) {
                return null;
            }
            return "<ul>" + result + "</ul>";
        }

        private String validateDateRange(DateRange dateRange) {
            if (!dateRange.isValid()) {
                return "From Date can't be after To Date.";
            }
            if (dateRange.getEndDate().after(new Date())) {
                return "End Date can't be set after today";
            }
            return null;
        }

        public String getFeedbackMsg() {
            return this.feedbackMsg;
        }

        public void setFeedbackMsg(String feedbackMsg) {
            this.feedbackMsg = feedbackMsg;
        }

        public DateRange getPrimaryDateRange() {
            return this.primaryDateRange;
        }

        public void setPrimaryDateRange(DateRange primaryDateRange) {
            this.primaryDateRange = primaryDateRange;
        }
    }
}

