/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.file.column;

import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.column.ModificationMachineColumn;
import com.pmease.quickbuild.plugin.report.changes.rest.RawModification;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ModificationMachinePanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public ModificationMachinePanel(String id, ModificationMachineColumn column, IModel<ItemContext> model) {
        super(id, model);
        String label;
        StringBuffer sb;
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        Map repositories = (Map)context.get("_REPOSITORIES");
        String repositoryName = row.getValueAsString("repository");
        if (repositories.size() > 1) {
            this.add(new Component[]{column.repositoryItem.createComponent("repository", model).setRenderBodyOnly(true)});
        } else {
            this.add(new Component[]{new Label("repository", repositoryName)});
        }
        this.add(new Component[]{column.changeIdItem.createComponent("changeId", model).setRenderBodyOnly(true)});
        RawModification m = new RawModification(row);
        if (ChangesHelper.canViewSource(m)) {
            sb = new StringBuffer();
            sb.append("<a class='edition-link' target='_default' href='").append(SourceViewPage.url4Edition((Long)row.getLong("buildId"), (String)row.getString("repository"), (String)row.getString("fileName"), (String)row.getString("edition"))).append("'>View</a>");
            label = sb.toString();
            this.add(new Component[]{this.createPageLink("viewLink", SourceViewPage.class, SourceViewPage.paramsFor((Long)row.getLong("buildId"), (String)row.getString("repository"), (String)row.getString("fileName"), (String)row.getString("edition")), "View")});
        } else {
            label = "<span class='disabled-link'>View</span>";
            this.add(new Component[]{new Label("viewLink", label).setEscapeModelStrings(false)});
        }
        if (ChangesHelper.canDiffSource(m)) {
            sb = new StringBuffer();
            sb.append("<a class='edition-link' target='_default' href='").append(SourceDiffPage.url4Edition((Long)row.getLong("buildId"), (String)row.getString("fileName"), (String)row.getString("repository"), (String)row.getString("edition"), (String)row.getString("previousEdition"))).append("'>Diff</a>");
            label = sb.toString();
            this.add(new Component[]{this.createPageLink("diffLink", SourceDiffPage.class, SourceDiffPage.paramsFor((Long)row.getLong("buildId"), (String)row.getString("fileName"), (String)row.getString("repository"), (String)row.getString("edition"), (String)row.getString("previousEdition")), "Diff")});
        } else {
            label = "<span class='disabled-link'>Diff</span>";
            this.add(new Component[]{new Label("diffLink", label).setEscapeModelStrings(false)});
        }
        if (column.getRenderer().getMode() == RendererMode.BUILD && ChangesHelper.hasComparingBuild()) {
            this.add(new Component[]{new Label("build", BuildUtils.hyperlinkBuild((Long)row.getLong("buildId"))).setEscapeModelStrings(false)});
        } else if (column.getRenderer().getMode() == RendererMode.STATISTICS) {
            this.add(new Component[]{new Label("build", BuildUtils.hyperlinkBuild((Long)row.getLong("buildId"))).setEscapeModelStrings(false)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("build").setVisible(false)});
        }
    }

    Component createPageLink(String id, Class<? extends WebPage> pageClass, PageParameters params, String label) {
        Fragment frag = new Fragment(id, "pageLink", (MarkupContainer)this);
        frag.add(new Component[]{new BookmarkablePageLink("link", pageClass, params).add(new Component[]{new Label("label", label)})});
        return frag;
    }
}

