/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.file.column;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.ChangeFormatterSupport;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.column.ModificationMachinePanel;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class ModificationMachineColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    final FilterLinkItem repositoryItem;
    final FilterLinkItem changeIdItem;

    public ModificationMachineColumn(TableRenderer renderer) {
        super((AbstractRenderer)renderer);
        this.repositoryItem = new FilterLinkItem((AbstractRenderer)renderer);
        this.repositoryItem.setValueExpression("repository");
        this.repositoryItem.setFilters((List)Lists.newArrayList((Object[])new SimpleFilterDef[]{new SimpleFilterDef("repository", "repository")}));
        this.repositoryItem.setTooltip("Show commits only in this repository");
        this.changeIdItem = new FilterLinkItem((AbstractRenderer)renderer){
            private static final long serialVersionUID = 1L;

            public String getText(ItemContext context) {
                String repositoryName;
                DataRow row = context.getDataRow();
                String changeId = row.getValueAsString("changeId");
                Map repositories = (Map)context.get("_REPOSITORIES");
                Repository repository = (Repository)repositories.get(repositoryName = row.getValueAsString("repository"));
                if (repository != null && repository instanceof ChangeFormatterSupport) {
                    changeId = ((ChangeFormatterSupport)repository).format("CHANGEID", this.buildExpressionContext(context));
                }
                return changeId;
            }
        };
        this.changeIdItem.setValueExpression("changeId");
        this.changeIdItem.setFilters((List)Lists.newArrayList((Object[])new SimpleFilterDef[]{new SimpleFilterDef("changeId", "changeId")}));
        this.changeIdItem.setTooltip("Show commits only in this changeset");
        this.setCss("machine");
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        return new ModificationMachinePanel(id, this, model);
    }
}

