/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.file.column;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.column.ModificationHumanColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ModificationHumanPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public ModificationHumanPanel(String id, ModificationHumanColumn column, IModel<ItemContext> model) {
        super(id, model);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        String comment = row.getValueAsString("comment");
        if (Strings.isNullOrEmpty((String)comment)) {
            this.add(new Component[]{new Label("comment", "<span class='orange'>No commit message</span>").setEscapeModelStrings(false)});
        } else {
            this.add(new Component[]{column.commentItem.createComponent("comment", model)});
        }
        Component c = column.actionItem.createComponent("action", model);
        c.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)row.getValueAsString("action").toLowerCase())), " ")});
        this.add(new Component[]{c});
        this.add(new Component[]{column.committerItem.createComponent("committer", model)});
        this.add(new Component[]{new Label("commitDate", DataTypes.TIME.asString(row.getValue("commitDate"), "age"))});
    }
}

