/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.file;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.changes.renderer.ChangesReportPanel;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.ByFileDataGrid;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.ByFileRenderer;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DataReportMapper;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.CompositeFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ContainsFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleExpression;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.wicket.model.IModel;

public class ByFileReportPanel
extends ChangesReportPanel {
    private static final long serialVersionUID = 1L;
    static Set<String> FIELDS_IN_CHANGESETS = Sets.newHashSet((Object[])new String[]{"comment", "committer", "userId", "commitDate"});

    public ByFileReportPanel(String id, ByFileRenderer renderer, IModel<RendererContext> contextModel) {
        super(id, renderer, contextModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportStats loadReportStats() {
        long start = System.currentTimeMillis();
        ReportStatsMetaData meta = this.getStatsMeta();
        ReportStats stats = new ReportStats(meta);
        DataRow row = stats.addRow();
        File dbDir = this.getDbDir();
        if (!dbDir.exists() || !this.isShowReports()) {
            return stats;
        }
        CategoryDb db = this.renderer.getCategory().getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "ByFileReportPanel::loadReportStats");
            SqlBuilder query = SqlBuilder.query();
            query.select(new String[]{"COUNT(*) AS TOTALS, COUNT(DISTINCT FILENAME) AS files"});
            List<Filter> filters = this.getFilters();
            if (filters.isEmpty()) {
                query.from(new String[]{"modifications"});
            } else {
                query.from(new String[]{"modifications, changesets"});
                query.where(new Filter[]{ByFileReportPanel.relationFilter()});
                query.where(filters);
            }
            Map map = db.queryForMap(query);
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Executing query " + query.toSqlString());
            }
            row.setValue("TOTALS", map.get("TOTALS"));
            row.setValue("files", map.get("files"));
            query = SqlBuilder.query();
            query.select(new String[]{"action, COUNT(*)"});
            if (filters.isEmpty()) {
                query.from(new String[]{"modifications"});
            } else {
                query.from(new String[]{"modifications, changesets"});
                query.where(new Filter[]{ByFileReportPanel.relationFilter()});
                query.where(filters);
            }
            query.groupby(new String[]{"modifications.action"});
            List list = db.queryForArrayList(query);
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Executing query " + query.toSqlString());
            }
            for (Object[] each : list) {
                String action = (String)each[0];
                if (Strings.isNullOrEmpty((String)action)) continue;
                Long value = (Long)each[1];
                row.setValue("action_" + action, (Object)value);
            }
            ReportStats reportStats = stats;
            return reportStats;
        }
        finally {
            db.close();
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Loading stats cost : " + (System.currentTimeMillis() - start) + " millis.");
            }
        }
    }

    @Override
    public List<Filter> getFilters() {
        Pair comparison;
        List<Filter> filters = super.getFilters();
        ArrayList actuals = Lists.newArrayList();
        for (Filter each : filters) {
            ContainsFilter f;
            if (each instanceof SimpleExpression) {
                SimpleExpression e = (SimpleExpression)each;
                String columnName = e.getColumnName();
                columnName = FIELDS_IN_CHANGESETS.contains(columnName) ? "changesets." + columnName : "modifications." + columnName;
                actuals.add(new SimpleExpression(columnName, e.getOp(), e.getValue()));
                continue;
            }
            if (each instanceof ContainsFilter) {
                f = (ContainsFilter)each;
                String[] columnNames = f.getColumns();
                ArrayList names = Lists.newArrayList();
                for (String column : columnNames) {
                    if (FIELDS_IN_CHANGESETS.contains(column)) {
                        names.add("changesets." + column);
                        continue;
                    }
                    names.add("modifications." + column);
                }
                actuals.add(new ContainsFilter(Joiner.on((String)",").join((Iterable)names), f.getPattern()));
                continue;
            }
            if (!(each instanceof CompositeFilter)) continue;
            f = (CompositeFilter)each;
            ArrayList list = Lists.newArrayList();
            for (SearchCriterion c : f.getCriterions()) {
                SearchCriterion created = new SearchCriterion(c);
                String columnName = created.getColumnName();
                if (FIELDS_IN_CHANGESETS.contains(columnName)) {
                    created.setColumnName("changesets." + columnName);
                } else {
                    created.setColumnName("modifications." + columnName);
                }
                list.add(created);
            }
            actuals.add(new CompositeFilter((List)list));
        }
        if (this.renderer.getMode() == RendererMode.BUILD && (comparison = SessionData.get().getComparisonBuild()) != null) {
            actuals.add(Restrictions.and((Filter)Restrictions.gt((String)"modifications.buildId", (Object)comparison.getFirst()), (Filter)Restrictions.le((String)"modifications.buildId", (Object)this.getBuild().getId())));
        }
        return actuals;
    }

    static Filter relationFilter() {
        return Restrictions.directSql((String)"modifications.changeId = changesets.changeId and modifications.repository = changesets.repository and modifications.buildId = changesets.buildId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ItemContext> iterator(int first, int count) {
        long start = System.currentTimeMillis();
        File dbDir = this.getDbDir();
        if (!dbDir.exists() || !this.isShowReports()) {
            return Iterators.emptyIterator();
        }
        DataReport report = this.renderer.getCategory().createReport("modifications");
        SqlBuilder query = SqlBuilder.query();
        query.select(new String[]{"modifications.*, changesets.committer, changesets.userId, changesets.comment, changesets.commitDate, changesets.additional"});
        query.from(new String[]{"modifications, changesets"});
        query.where(new Filter[]{ByFileReportPanel.relationFilter()});
        List<Filter> filters = this.getFilters();
        query.where(filters);
        query.orderby(new Order[]{new Order("modifications.repository", true), new Order("modifications.fileName", true), new Order("changesets.commitDate", false)});
        query.limit(count);
        query.offset(first);
        CategoryDb db = this.renderer.getCategory().getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "ByFileReportPanel::iterator");
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Executing query " + query.toSqlString());
            }
            report = (DataReport)db.query(query, (ResultSetHandler)new DataReportMapper(report));
            List rows = report.getRows();
            ArrayList list = Lists.newArrayList();
            for (DataRow each : rows) {
                ItemContext context = this.createItemContext(each);
                list.add(context);
            }
            Iterator<ItemContext> iterator = list.iterator();
            return iterator;
        }
        finally {
            db.close();
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Loading rows cost : " + (System.currentTimeMillis() - start) + " millis.");
            }
        }
    }

    public ItemContext createItemContext(DataRow row) {
        ItemContext context = super.createItemContext(row);
        context.put("_REPOSITORIES", this.getRepositories());
        return context;
    }

    protected ReportStatsMetaData getStatsMeta() {
        ReportMetaData meta = this.renderer.getCategory().getMeta("modifications");
        ReportStatsMetaData statsMeta = new ReportStatsMetaData(meta, true);
        statsMeta.addColumn(new DataColumn("files", (DataType)new LongType()));
        return statsMeta;
    }

    protected DataGrid newDataGrid(String id) {
        return new ByFileDataGrid(id, this.getColumns(), new ReportDataProvider((TableReportPanel)this), this);
    }

    public ByFileRenderer getRenderer() {
        return (ByFileRenderer)super.getRenderer();
    }
}

