/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.file;

import com.google.common.base.Objects;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.file.ByFileReportPanel;
import com.pmease.quickbuild.plugin.report.changes.rest.RawModification;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.GroupableDataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ByFileDataGrid
extends GroupableDataGrid {
    private static final long serialVersionUID = 1L;

    public ByFileDataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, ByFileReportPanel parentPanel) {
        super(id, columns, dataProvider, (TableReportPanel)parentPanel);
    }

    protected Item<ItemContext> newRowItem(String id, int index, IModel<ItemContext> rowModel) {
        Item item = super.newRowItem(id, index, rowModel);
        item.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"subrow")))});
        item.add(new Behavior[]{new GroupableDataGrid.GroupBehavior((GroupableDataGrid)this)});
        return item;
    }

    protected boolean isGroupRow(DataRow current) {
        if (this.previous == null) {
            return true;
        }
        return !Objects.equal((Object)this.previous.getValue("repository"), (Object)current.getValue("repository")) || !Objects.equal((Object)this.previous.getValue("fileName"), (Object)current.getValue("fileName"));
    }

    protected String getGroupRowHtml(DataRow row) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr class='group-row'><td colspan='").append(this.getColumns().size()).append("'><h3>");
        String fileName = row.getValueAsString("fileName");
        RawModification m = new RawModification(row);
        if (ChangesHelper.canViewSource(m)) {
            sb.append("<a target='_default' class='black' href='").append(SourceViewPage.url4Revision((Long)row.getLong("buildId"), (String)row.getString("repository"), (String)row.getString("fileName"))).append("'>").append(fileName).append("</a>");
        } else {
            sb.append(fileName);
        }
        if (ChangesHelper.canDiffSource(m) && this.getRenderer().getMode() != RendererMode.STATISTICS) {
            Build previous;
            sb.append("    <span style='float: right' class='light-text'>");
            Long buildId = row.getLong("buildId");
            if (ChangesHelper.hasComparingBuild()) {
                previous = ChangesHelper.getComparisonBuild();
            } else {
                BuildManager bm = (BuildManager)Quickbuild.getInstance(BuildManager.class);
                Build b = (Build)bm.get(buildId);
                previous = bm.getPrevious(b);
            }
            if (previous != null && !Objects.equal((Object)buildId, (Object)previous.getId())) {
                sb.append("<a class='edition-link' target='_default' href='").append(SourceDiffPage.url4Revision((Long)row.getLong("buildId"), (Long)previous.getId(), (String)row.getString("repository"), (String)row.getString("fileName"))).append("'>Diff Previous</a>");
            }
            sb.append("</span>");
        }
        sb.append("</h3></td></tr>");
        return sb.toString();
    }
}

