/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset.dropdown;

import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.rest.RawModification;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

class ModificationPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public ModificationPanel(String id, IModel<ItemContext> model) {
        super(id, model);
        String label;
        StringBuffer sb;
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        WebMarkupContainer action = new WebMarkupContainer("action");
        action.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)row.getValueAsString("action").toLowerCase())), " ")});
        this.add(new Component[]{action});
        this.add(new Component[]{new Label("filePath", row.getValueAsString("fileName"))});
        RawModification m = new RawModification(row);
        String repositoryName = row.getValueAsString("repository");
        if (ChangesHelper.canViewSource(m)) {
            sb = new StringBuffer();
            sb.append("<a class='edition-link' target='_default' href='").append(ChangesHelper.getViewSourceUrl(row.getLong("buildId"), repositoryName, m)).append("'>View</a>");
            label = sb.toString();
        } else {
            label = "<span class='disabled-link'>View</span>";
        }
        this.add(new Component[]{new Label("viewLink", label).setEscapeModelStrings(false)});
        if (ChangesHelper.canDiffSource(m)) {
            sb = new StringBuffer();
            sb.append("<a class='edition-link' target='_default' href='").append(ChangesHelper.getDiffSourceUrl(row.getLong("buildId"), repositoryName, m)).append("'>Diff</a>");
            label = sb.toString();
        } else {
            label = "<span class='disabled-link'>Diff</span>";
        }
        this.add(new Component[]{new Label("diffLink", label).setEscapeModelStrings(false)});
    }
}

