/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset.dropdown;

import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.ChangesReportPanel;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.dropdown.ModificationColumn;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbarCreator;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ToolbarCreator;
import java.io.File;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class ModificationDropDownRenderer
extends TableRenderer {
    private static final long serialVersionUID = 1L;

    public ModificationDropDownRenderer(ReportCategory category) {
        super(category);
        ReportDataSource rds = new ReportDataSource(category);
        rds.setFrom("modifications");
        this.setDataSource(rds);
        this.setInDropDown(true);
        this.addColumn(new ModificationColumn(this));
        SearchNavToolbarCreator sn = new SearchNavToolbarCreator((TableRenderer)this);
        sn.setShowSearchForm(false);
        sn.setPosition(ToolbarCreator.ToolbarPosition.BOTTOM);
        this.addToolbar((ToolbarCreator)sn);
    }

    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new ChangesReportPanel(id, this, model){
            private static final long serialVersionUID = 1L;

            @Override
            public File getDbDir() {
                AbstractRenderer parent = ModificationDropDownRenderer.this.getParentRenderer();
                if (parent.getMode() == RendererMode.BUILD && !ChangesHelper.hasComparingBuild() || parent.getMode() == RendererMode.DASHBOARD) {
                    return ModificationDropDownRenderer.this.getCategory().getReportDirOfBuild(this.getBuild(), "DEFAULT");
                }
                return ModificationDropDownRenderer.this.getCategory().getReportDirOfStats(this.getConfiguration(), "DEFAULT");
            }
        };
    }
}

