/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column;

import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.ChangeFormatterSupport;
import com.pmease.quickbuild.plugin.report.changes.renderer.ChangesReportPanel;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column.CommitMachineColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class CommitMachinePanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CommitMachinePanel(String id, IModel<ItemContext> model, CommitMachineColumn column) {
        super(id, model);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        String changeId = row.getValueAsString("changeId");
        ChangesReportPanel reportPanel = (ChangesReportPanel)context.getReportPanel();
        Map<String, Repository<?>> repositories = reportPanel.getRepositories();
        String repositoryName = row.getValueAsString("repository");
        Repository<?> repository = repositories.get(repositoryName);
        if (repository != null && repository instanceof ChangeFormatterSupport) {
            changeId = ((ChangeFormatterSupport)repository).format("CHANGEID", context.getExpressionContext());
        }
        if (repositories.size() > 1) {
            this.add(new Component[]{column.repositoryItem.createComponent("repository", model).setRenderBodyOnly(true)});
        } else {
            this.add(new Component[]{new Label("repository", " " + repositoryName)});
        }
        this.add(new Component[]{new Label("changeId", changeId)});
        RendererMode mode = column.getRenderer().getMode();
        if (mode == RendererMode.BUILD && ChangesHelper.hasComparingBuild()) {
            this.add(new Component[]{new Label("build", BuildUtils.hyperlinkBuild((Long)row.getLong("buildId"))).setEscapeModelStrings(false)});
        } else if (mode == RendererMode.STATISTICS) {
            String link;
            BuildFragment b = BuildUtils.getBuildFragment((Long)row.getLong("buildId"));
            if (b == null) {
                link = "<span class='red'>Non-exist build: #" + row.getValueAsString("buildId") + "</span>";
            } else {
                link = BuildUtils.getBuildUrl((BuildFragment)b);
                link = new StringBuffer("<a href='").append(link).append("/scm_changes").append("' class='build-status ").append(b.getStatus().name().toLowerCase()).append("'>").append(b.getVersion()).append("</a>").toString();
            }
            this.add(new Component[]{new Label("build", link).setEscapeModelStrings(false)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("build").setVisible(false)});
        }
    }
}

