/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column;

import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column.CommitHumanColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class CommitHumanPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CommitHumanPanel(String id, IModel<ItemContext> model, CommitHumanColumn column) {
        super(id, model);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        String comment = row.getValueAsString("comment");
        if (StringUtils.isEmpty((String)comment)) {
            this.add(new Component[]{new Label("comment", "<span class='orange'>No commit message</span>").setEscapeModelStrings(false)});
        } else {
            this.add(new Component[]{column.commentItem.createComponent("comment", model)});
        }
        this.add(new Component[]{column.modificationDropDown.createComponent("modifications", model).setRenderBodyOnly(true)});
        this.add(new Component[]{column.committerItem.createComponent("committer", model)});
        this.add(new Component[]{new Label("commitDate", DataTypes.TIME.asString(row.getValue("commitDate"), "age"))});
    }
}

