/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.changes.renderer.CommentItem;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column.CommitHumanPanel;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.dropdown.ModificationDropDownItem;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class CommitHumanColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    final FilterLinkItem committerItem;
    final CommentItem commentItem;
    final ModificationDropDownItem modificationDropDown;

    public CommitHumanColumn(TableRenderer renderer) {
        super((AbstractRenderer)renderer);
        this.commentItem = new CommentItem(renderer);
        this.commentItem.setValueExpression("comment");
        this.committerItem = new FilterLinkItem((AbstractRenderer)renderer);
        this.committerItem.setValueExpression("committer");
        this.committerItem.setFilters((List)Lists.newArrayList((Object[])new SimpleFilterDef[]{new SimpleFilterDef("committer", "committer")}));
        this.modificationDropDown = new ModificationDropDownItem(renderer, "buildId, repository, changeId");
        this.modificationDropDown.setValueExpression("modifications");
        this.modificationDropDown.setEnabledExpression("modifications > 0");
        this.setCss("human");
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        return new CommitHumanPanel(id, model, this).setRenderBodyOnly(true);
    }

    public FilterLinkItem getCommitterItem() {
        return this.committerItem;
    }

    public CommentItem getCommentItem() {
        return this.commentItem;
    }

    public ModificationDropDownItem getModificationDropDown() {
        return this.modificationDropDown;
    }
}

