/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer.changeset;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.AbstractChangesetRenderer;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.GroupType;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.GroupableDataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ChangesetDataGrid
extends GroupableDataGrid {
    private static final long serialVersionUID = 1L;

    public ChangesetDataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, TableReportPanel parentPanel) {
        super(id, columns, dataProvider, parentPanel);
    }

    protected GroupType getGroupType() {
        RendererMode mode = this.getRenderer().getMode();
        GroupType type = this.getRenderer().getGroupType();
        if (type == null) {
            if (mode == RendererMode.DASHBOARD) {
                return GroupType.BY_DAY;
            }
            if (mode == RendererMode.BUILD) {
                if (ChangesHelper.hasComparingBuild()) {
                    return GroupType.BY_BUILD;
                }
                return GroupType.BY_DAY;
            }
            return null;
        }
        return type;
    }

    protected Item<ItemContext> newRowItem(String id, int index, IModel<ItemContext> rowModel) {
        Item item = super.newRowItem(id, index, rowModel);
        item.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"subrow")))});
        item.add(new Behavior[]{new GroupableDataGrid.GroupBehavior((GroupableDataGrid)this)});
        return item;
    }

    protected boolean isGroupRow(DataRow current) {
        GroupType type = this.getGroupType();
        if (type == null) {
            return false;
        }
        if (this.previous == null) {
            return true;
        }
        switch (type) {
            case BY_DAY: {
                Calendar currentDate = (Calendar)current.getValue("commitDate");
                Calendar previousDate = (Calendar)this.previous.getValue("commitDate");
                if (currentDate == null || previousDate == null) {
                    return true;
                }
                return !DateUtils.isSameDay((Calendar)currentDate, (Calendar)previousDate);
            }
            case BY_BUILD: {
                Long currentId = current.getLong("buildId");
                Long previousId = this.previous.getLong("buildId");
                return !Objects.equal((Object)currentId, (Object)previousId);
            }
            case BY_USER: {
                String currentCommitter = current.getValueAsString("committer");
                String previousCommitter = this.previous.getValueAsString("committer");
                return !Objects.equal((Object)currentCommitter, (Object)previousCommitter);
            }
        }
        return false;
    }

    public AbstractChangesetRenderer getRenderer() {
        return (AbstractChangesetRenderer)super.getRenderer();
    }

    protected String getGroupRowHtml(DataRow row) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr class='group-row");
        if (this.previous == null) {
            sb.append(" first");
        }
        sb.append("'><td");
        int columns = this.getColumns().size();
        if (this.previous == null) {
            sb.append(">");
        } else {
            sb.append(" colspan=").append(columns).append(">");
        }
        sb.append("<h2>");
        switch (this.getGroupType()) {
            case BY_DAY: {
                Calendar commitDate = (Calendar)row.getValue("commitDate");
                if (commitDate == null) {
                    sb.append("Unknown Date");
                    break;
                }
                sb.append(DataTypes.TIME.asString((Object)commitDate, "EEEEE, MMMMM d"));
                break;
            }
            case BY_BUILD: {
                Long buildId = row.getLong("buildId");
                sb.append(BuildUtils.hyperlinkBuild((Long)buildId));
                BuildFragment b = BuildUtils.getBuildFragment((Long)buildId);
                if (b == null) break;
                sb.append(" <span class='light-text'>(").append(DataTypes.DATE.asString((Object)b.getBeginDate(), "EEEEE, MMMMM d")).append(")</span>");
                break;
            }
            case BY_USER: {
                sb.append(row.getValueAsString("committer"));
                break;
            }
        }
        sb.append("</h2>");
        sb.append("</td>");
        if (this.previous == null && columns > 1) {
            sb.append("<td class='commit-count nowrap-text'").append(" colspan=").append(columns - 1).append(">").append("<div class='counters clearfix'>\t<span class='replaced modification add'></span>\t<span class='replaced modification modify'></span>\t<span class='replaced modification delete'></span></div></td>");
        }
        sb.append("</tr>");
        return sb.toString();
    }
}

