/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SourceViewLink
extends Link<ItemContext> {
    private static final long serialVersionUID = 1L;

    public SourceViewLink(String id, IModel<ItemContext> model) {
        super(id, model);
        this.setPopupSettings(new PopupSettings("popup", 12));
    }

    protected ItemContext getContext() {
        return (ItemContext)this.getDefaultModelObject();
    }

    public void onClick() {
        if (!SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name())) {
            throw new AccessDeniedException("You dont have permission to access the source code");
        }
        DataRow row = this.getContext().getDataRow();
        PageParameters params = new PageParameters();
        params.add("file", (Object)row.getValueAsString("fileName"));
        params.add("repository", (Object)row.getValueAsString("repository"));
        params.add("edition", (Object)row.getValueAsString("edition"));
        params.add("build", (Object)row.getValueAsString("buildId"));
        this.setResponsePage((Page)new SourceViewPage(params));
    }
}

