/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.CommentTransformer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class CommentItem
extends TextItem {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXT = "commentitem.context";

    public CommentItem(TableRenderer renderer) {
        super((AbstractRenderer)renderer);
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        final ItemContext context = (ItemContext)model.getObject();
        final String value = this.getText(context);
        Label commentLabel = new Label(id, (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                if (StringUtils.isEmpty((String)value)) {
                    return "";
                }
                List transformers = ((PluginManager)Quickbuild.getInstance(PluginManager.class)).getExtensions(CommentTransformer.class);
                TableReportPanel reportPanel = (TableReportPanel)context.getReportPanel();
                Map data = reportPanel.getData();
                data.put(CommentItem.CONTEXT, context);
                String comment = ReportUtils.wrapAsHtmlMultiline((String)value, (int)0);
                for (CommentTransformer each : transformers) {
                    if (!each.isApplicable()) continue;
                    comment = each.transform(comment, data);
                }
                return "<span class='commit-comment'>" + comment + "</span>";
            }
        });
        commentLabel.setEscapeModelStrings(false).setRenderBodyOnly(true);
        return commentLabel;
    }
}

