/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer;

import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.ComparisonBuildChanged;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ChangesReportPanel
extends TableReportPanel {
    private static final long serialVersionUID = 1L;
    final IModel<Map<String, Repository<?>>> repositoriesModel = new LoadableDetachableModel<Map<String, Repository<?>>>(){
        private static final long serialVersionUID = 1L;

        protected Map<String, Repository<?>> load() {
            return ChangesReportPanel.this.loadRepositories();
        }
    };

    public ChangesReportPanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected String getDefaultScript() {
        String script = super.getDefaultScript();
        script = script + "$('#" + this.dataGrid.getMarkupId() + " .issue-link[title]').animatetip();";
        return script;
    }

    public List<Filter> getFilters() {
        Pair comparison;
        List filters = super.getFilters();
        if (this.renderer.getMode() == RendererMode.BUILD && (comparison = SessionData.get().getComparisonBuild()) != null) {
            filters.add(Restrictions.and((Filter)Restrictions.gt((String)"buildId", (Object)comparison.getFirst()), (Filter)Restrictions.le((String)"buildId", (Object)this.getBuild().getId())));
        }
        return filters;
    }

    public Map<String, Repository<?>> getRepositories() {
        return (Map)this.repositoriesModel.getObject();
    }

    protected Map<String, Repository<?>> loadRepositories() {
        Configuration configuration = this.getConfiguration();
        return configuration.findRepositories();
    }

    public File getDbDir() {
        RendererMode mode = this.renderer.getMode();
        boolean compare = ChangesHelper.hasComparingBuild();
        ReportCategory category = this.renderer.getCategory();
        switch (mode) {
            case DASHBOARD: 
            case BUILD_SUMMARY: {
                return category.getReportDirOfBuild(this.getBuild(), "DEFAULT");
            }
            case BUILD: {
                if (compare) {
                    return category.getReportDirOfStats(this.getConfiguration(), "DEFAULT");
                }
                return category.getReportDirOfBuild(this.getBuild(), "DEFAULT");
            }
        }
        return category.getReportDirOfStats(this.getConfiguration(), "DEFAULT");
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof DateRangeChanged) {
            this.onEvent((DateRangeChanged)sink.getPayload());
        } else if (sink.getPayload() instanceof ComparisonBuildChanged) {
            this.onEvent((ComparisonBuildChanged)((Object)sink.getPayload()));
        }
    }

    public void onEvent(DateRangeChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(ComparisonBuildChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    public void onDetach() {
        this.repositoriesModel.detach();
        super.onDetach();
    }
}

