/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.ComparisonBuildChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.DefaultReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.web.BuildChoice;
import com.pmease.quickbuild.util.Pair;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ChangesHeaderPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected DefaultReportPanel parentPanel;

    public ChangesHeaderPanel(String id, DefaultReportPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
    }

    public void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return ChangesHeaderPanel.this.getTitle();
            }
        }).setOutputMarkupId(true).setEscapeModelStrings(false)});
        String description = this.parentPanel.getRenderer().getDescription();
        this.add(new Component[]{new Label("description", description).setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)description))});
        this.add(new Component[]{new ComparisonForm("comparisonForm")});
    }

    protected String getTitle() {
        String title = this.parentPanel.getRenderer().getTitle();
        Pair comparisonBuild = SessionData.get().getComparisonBuild();
        if (comparisonBuild != null) {
            title = title + " <span class='light-text'>(Since " + BuildUtils.hyperlinkBuild((Long)((Long)comparisonBuild.getFirst())) + ")</span>";
        }
        return title;
    }

    protected String getBuildChoiceLabel() {
        return "View changes since: ";
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof ComparisonBuildChanged) {
            ((ComparisonBuildChanged)((Object)sink.getPayload())).getTarget().add(new Component[]{this.get("title")});
        }
    }

    private class ComparisonForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;
        private String buildVersion;

        public ComparisonForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
            this.add(new Component[]{new Label("buildChoiceLabel", ChangesHeaderPanel.this.getBuildChoiceLabel())});
            Build comparingBuild = ChangesHelper.getComparisonBuild();
            this.buildVersion = comparingBuild == null ? "VERSION" : comparingBuild.getVersion();
            AjaxButton submit = new AjaxButton("submitBtn"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    Build build;
                    block8: {
                        BuildManager buildManager = (BuildManager)Quickbuild.getInstance(BuildManager.class);
                        if (StringUtils.isEmpty((String)ComparisonForm.this.buildVersion) || ComparisonForm.this.buildVersion.equalsIgnoreCase("VERSION")) {
                            target.add(new Component[]{form});
                            this.send((IEventSink)ChangesHeaderPanel.this.parentPanel, Broadcast.BREADTH, (Object)new ComparisonBuildChanged(target, null));
                            return;
                        }
                        if (ComparisonForm.this.buildVersion.charAt(0) == '#') {
                            try {
                                Long id = Long.valueOf(ComparisonForm.this.buildVersion.substring(1));
                                build = (Build)buildManager.get(id);
                                if (build == null || build.getConfiguration().getId().longValue() != Context.getConfiguration().getId().longValue()) {
                                    this.getSession().error((Serializable)((Object)"No build found in current configuration with such id"));
                                    target.add(new Component[]{form});
                                    return;
                                }
                                break block8;
                            }
                            catch (NumberFormatException e) {
                                this.getSession().error((Serializable)((Object)"Invalid format of build id, please use below format: #buildId or just input build version."));
                                target.add(new Component[]{form});
                                return;
                            }
                        }
                        SearchCriteria criteria = new SearchCriteria(new Criterion[]{Restrictions.eq((String)"version", (Object)ComparisonForm.this.buildVersion), Restrictions.eq((String)"configuration", (Object)Context.getConfiguration())}, new Order[]{Order.desc((String)"id")});
                        List builds = buildManager.search(criteria, 0, 1);
                        if (builds.isEmpty()) {
                            this.getSession().error((Serializable)((Object)"Can't find any build with such version."));
                            target.add(new Component[]{form});
                            return;
                        }
                        build = (Build)builds.get(0);
                    }
                    if (build.getId() > Context.getBuild().getId()) {
                        this.getSession().error((Serializable)((Object)"Only can compare with the previous build."));
                        target.add(new Component[]{form});
                        return;
                    }
                    if (build.getId().longValue() == Context.getBuild().getId().longValue()) {
                        return;
                    }
                    Pair comparisonBuild = new Pair((Object)build.getId(), (Object)build.getVersion());
                    target.add(new Component[]{form});
                    this.send((IEventSink)ChangesHeaderPanel.this.parentPanel, Broadcast.BREADTH, (Object)new ComparisonBuildChanged(target, (Pair<Long, String>)comparisonBuild));
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            };
            this.add(new Component[]{submit});
            this.setDefaultButton((IFormSubmittingComponent)submit);
            this.add(new Component[]{new BuildChoice("comparingPanel", (IModel)new PropertyModel((Object)this, "buildVersion")){
                private static final long serialVersionUID = 1L;

                protected void OnShortcut(BuildChoice.BuildShortcut shortcut, AjaxRequestTarget target) {
                    Pair comparisonBuild;
                    Build build;
                    switch (shortcut) {
                        case PREVIOUS_SUCCESSFUL: {
                            build = BuildUtils.getPrevious((Build.Status)Build.Status.SUCCESSFUL);
                            break;
                        }
                        case LATEST_RECOMMENDED: {
                            build = BuildUtils.getPrevious((Build.Status)Build.Status.RECOMMENDED);
                            break;
                        }
                        case PREVIOUS_FAILED: {
                            build = BuildUtils.getPrevious((Build.Status)Build.Status.FAILED);
                            break;
                        }
                        case ALL_BUILDS: {
                            build = ((BuildManager)Quickbuild.getInstance(BuildManager.class)).getFirst(Context.getConfiguration());
                            break;
                        }
                        default: {
                            build = null;
                        }
                    }
                    if (build == null) {
                        ComparisonForm.this.buildVersion = "VERSION";
                        comparisonBuild = null;
                    } else {
                        ComparisonForm.this.buildVersion = build.getVersion();
                        comparisonBuild = new Pair((Object)build.getId(), (Object)build.getVersion());
                    }
                    target.add(new Component[]{ComparisonForm.this});
                    this.send((IEventSink)ChangesHeaderPanel.this.parentPanel, Broadcast.BREADTH, (Object)new ComparisonBuildChanged(target, (Pair<Long, String>)comparisonBuild));
                }

                protected CharSequence getBuildChangedJavascript(BuildFragment build) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("$('").append(ComparisonForm.this.getMarkupId()).append("').submit();");
                    return sb.toString();
                }
            }});
        }
    }
}

