/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.migration;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.report.changes.ChangesCategory;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesMigrator
extends ReportCategoryMigrator {
    private static final Logger logger = LoggerFactory.getLogger(ChangesMigrator.class);
    static final String[] PRIMARY_KEYS = new String[]{"buildId", "changeId", "repository"};

    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        ChangesCategory category = (ChangesCategory)context.getCategory();
        Build build = context.getBuild();
        Configuration configuration = build != null ? build.getConfiguration() : context.getConfiguration();
        if (build != null) {
            try {
                this.migrateBuildReport1(category, build, context.getDir());
            }
            catch (Exception e) {
                if (context.getDir().exists()) {
                    Collection files = FileUtils.listFiles((File)context.getDir(), (String)"**/*.h2.db");
                    for (File each : files) {
                        FileUtils.deleteFile((File)each);
                    }
                }
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        try {
            this.migrateStatsReport1(category, configuration, context.getDir(), context);
        }
        catch (Exception e) {
            if (context.getDir().exists()) {
                Collection files = FileUtils.listFiles((File)context.getDir(), (String)"**/*.h2.db");
                for (File each : files) {
                    FileUtils.deleteFile((File)each);
                }
            }
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateBuildReport1(ChangesCategory category, Build build, File categoryDir) {
        File statsDir;
        if (logger.isDebugEnabled()) {
            logger.debug("Migrating changes from XML to database for build " + build.getId() + ", direcotory: " + categoryDir + " ...");
        }
        if (!(statsDir = category.getChangesDirOfStats(build.getConfiguration())).exists()) {
            return;
        }
        Lock lock = LockUtils.lockForWrite((File)categoryDir);
        try {
            File dbDir;
            if (!statsDir.exists()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Category data directory Read-write lock acquired");
            }
            if ((dbDir = new File(categoryDir, "DEFAULT")).exists()) {
                logger.info("Changes directory exists, delete it");
                FileUtils.deleteDir((File)dbDir);
            }
            FileUtils.createDir((File)dbDir);
            CategoryDb db = category.getCategoryDb(dbDir);
            try {
                db.open(DbStore.Mode.READ_WRITE, "ChangesMigrator::migrateBuildReport1");
                if (logger.isDebugEnabled()) {
                    logger.debug("Database READ-WRITE lock acquired");
                }
                DataReport report = category.loadReport(statsDir, "changesets", new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
                category.saveReport(db, report);
                HashSet<String> keys = new HashSet<String>();
                for (DataRow each : report.getRows()) {
                    keys.add(each.getRowKeyString(PRIMARY_KEYS));
                }
                report = category.loadReport(statsDir, "modifications", new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
                Iterator it = report.getRows().iterator();
                while (it.hasNext()) {
                    DataRow each;
                    each = (DataRow)it.next();
                    String key = each.getRowKeyString(PRIMARY_KEYS);
                    String fileName = each.getValueAsString("fileName");
                    if (keys.contains(key) && !Strings.isNullOrEmpty((String)fileName)) continue;
                    it.remove();
                }
                category.saveReport(db, report);
                report = category.loadReport(statsDir, "stats", new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
                category.saveReport(db, report);
            }
            finally {
                db.close();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateStatsReport1(ChangesCategory category, Configuration configuration, File categoryDir, MigrationContext context) {
        File dbDir = new File(categoryDir, "DEFAULT");
        File buildsDir = new File(categoryDir, "builds");
        if (!buildsDir.exists()) {
            return;
        }
        logger.info("Migrating changes history from XML to database for configuration " + configuration.getPathName() + ", directory: " + categoryDir);
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "ChangesMigrator::migrateStatsReport1");
            if (!buildsDir.exists()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Database READ-WRITE lock acquired");
            }
            Collection files = FileUtils.listFiles((File)buildsDir, (String)"**/changesets.xml");
            HashSet<Long> buildIds = new HashSet<Long>();
            ReportMetaData meta = category.getMeta("changesets");
            ReportMetaData previousMeta = meta.newInstance();
            previousMeta.renameColumn("committer", "users");
            HashMap<String, Long> committerMapping = new HashMap<String, Long>();
            Map repositories = configuration.findRepositories();
            for (File each : files) {
                File dir;
                Long id;
                if (logger.isDebugEnabled()) {
                    logger.debug("Migrating changesets, file '" + each + "' to database ...");
                }
                if ((id = (Long)DataTypes.LONG.fromString((dir = each.getParentFile()).getName(), null)) == null) continue;
                if (buildIds.contains(id)) {
                    logger.info("Encounter duplicated build id " + id + " while migrating changes, deleting all old changes and modifications of this build.");
                    db.update("DELETE FROM modifications WHERE buildId = " + id);
                    db.update("DELETE FROM changesets WHERE buildId = " + id);
                } else {
                    buildIds.add(id);
                }
                ReportMetaData cloned = previousMeta.newInstance();
                DataReport report = new DataReport(cloned);
                report.loadFromXML(each);
                cloned.renameColumn("users", "committer");
                this.updateUserId(report, repositories, committerMapping);
                HashSet keys = Sets.newHashSet();
                Iterator it = report.getRows().iterator();
                while (it.hasNext()) {
                    DataRow row = (DataRow)it.next();
                    String key = row.getRowKeyString(PRIMARY_KEYS);
                    if (keys.contains(key)) {
                        it.remove();
                        continue;
                    }
                    keys.add(key);
                }
                category.saveReport(db, report);
                File modificationFile = new File(dir, "modifications.xml");
                if (logger.isDebugEnabled()) {
                    logger.debug("Migrating modifications, file '" + modificationFile + "' to database ...");
                }
                report = category.createReport("modifications");
                report.loadFromXML(modificationFile);
                Iterator it2 = report.getRows().iterator();
                while (it2.hasNext()) {
                    DataRow row = (DataRow)it2.next();
                    String key = row.getRowKeyString(PRIMARY_KEYS);
                    String fileName = row.getValueAsString("fileName");
                    if (keys.contains(key) && !Strings.isNullOrEmpty((String)fileName)) continue;
                    it2.remove();
                }
                category.saveReport(db, report);
            }
            this.stats3To4(context, db);
        }
        finally {
            db.close();
        }
    }

    protected void stats3To4(MigrationContext context, CategoryDb db) {
        File reportDir = db.getDbDir();
        ReportCategory category = db.getCategory();
        Collection files = FileUtils.listFiles((File)reportDir, (String)"**/changes.xml");
        ReportMetaData meta = category.getMeta("stats");
        HashSet set = Sets.newHashSet();
        for (File file : files) {
            DataReport report = new DataReport(meta);
            report.loadFromXML(file);
            for (DataRow each : report.getRows()) {
                Long buildId = each.getLong("buildId");
                if (set.contains(buildId)) {
                    SqlBuilder sql = SqlBuilder.deleteFrom((String)"stats").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)buildId)});
                    db.update(sql);
                }
                db.persistRow(each);
                set.add(buildId);
            }
        }
    }

    private void updateUserId(DataReport changesReport, Map<String, Repository<?>> repositories, Map<String, Long> committerMapping) {
        UserManager um = (UserManager)Quickbuild.getInstance(UserManager.class);
        for (DataRow row : changesReport.getRows()) {
            User u;
            Repository<?> repository;
            String username;
            String repositoryName = row.getValueAsString("repository");
            String committer = row.getValueAsString("committer");
            if (!repositories.containsKey(repositoryName)) {
                row.setValue("userId", (Object)-1L);
                continue;
            }
            if (Strings.isNullOrEmpty((String)committer)) {
                row.setValue("userId", (Object)-1L);
                continue;
            }
            String key = repositoryName + ":" + committer;
            Long userId = committerMapping.get(key);
            if (userId == null && !Strings.isNullOrEmpty((String)(username = (repository = repositories.get(repositoryName)).getUserName(committer))) && (u = um.get(username)) != null) {
                userId = u.getId();
                committerMapping.put(key, userId);
            }
            row.setValue("userId", (Object)userId);
        }
    }
}

