/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.localchanges;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.changes.localchanges.LocalChangePanel;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.wicket.markup.html.panel.Panel;

public class LocalChangesBuildTabContribution
implements BuildTabContribution {
    private static final long serialVersionUID = 1L;

    public int getOrder() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tab> getTabs() {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        final Build build = Context.getBuild();
        if (SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            File localChangeDir = new File(build.getPublishDir(), "local_change");
            int count = 0;
            Lock lock = LockUtils.lockForRead((File)localChangeDir);
            try {
                if (localChangeDir.exists()) {
                    File[] dirs;
                    for (File dir : dirs = localChangeDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File dir) {
                            return build.getRepository(dir.getName()) != null;
                        }
                    })) {
                        LocalChange localChange = (LocalChange)BeanUtils.readFile((File)new File(dir, "info"), (MigrationListener)new MigrationListener(){

                            public void afterMigration(Object bean) {
                            }
                        }, LocalChange.class);
                        count += localChange.getDeletePaths().size();
                        count += localChange.getModifyPaths().size();
                        count += localChange.getAddPaths().size();
                    }
                }
            }
            finally {
                lock.unlock();
            }
            if (count != 0) {
                tabs.add(new Tab("Local Change", "Local Change (" + count + ")"){
                    private static final long serialVersionUID = 1L;

                    public Panel getPanel(String id, Map<String, String> params) {
                        return new LocalChangePanel(id);
                    }
                });
            }
        }
        return tabs;
    }
}

