/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.localchanges;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.page.error.ErrorMessagePage;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class LocalChangePanel
extends Panel {
    public LocalChangePanel(String panelId) {
        super(panelId);
        final boolean viewSourceAllowed = SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name());
        this.add(new Component[]{new ListView("repositories", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                File localChangeDir = new File(Context.getBuild().getPublishDir(), "local_change");
                if (localChangeDir.exists()) {
                    File[] dirs = localChangeDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File dir) {
                            return Context.getBuild().getRepository(dir.getName()) != null;
                        }
                    });
                    return Arrays.asList(dirs);
                }
                return new ArrayList();
            }
        }){

            protected void populateItem(ListItem item) {
                File localChangeDir = (File)item.getModelObject();
                final Repository repository = Context.getBuild().getRepository(localChangeDir.getName());
                final LocalChange localChange = (LocalChange)BeanUtils.readFile((File)new File(localChangeDir, "info"), (MigrationListener)new MigrationListener(){

                    public void afterMigration(Object bean) {
                    }
                }, LocalChange.class);
                final File localChangeStoreDir = new File(localChangeDir, "store");
                item.add(new Component[]{new Label("repositoryName", repository.getName())});
                item.add(new Component[]{new ListView("modifications", (IModel)new LoadableDetachableModel(){

                    protected Object load() {
                        ArrayList<Pair> modifications = new ArrayList<Pair>();
                        FileUtils.sortPaths((List)localChange.getDeletePaths());
                        for (String path : localChange.getDeletePaths()) {
                            modifications.add(new Pair((Object)Action.DELETE, (Object)path));
                        }
                        FileUtils.sortPaths((List)localChange.getAddPaths());
                        for (String path : localChange.getAddPaths()) {
                            modifications.add(new Pair((Object)Action.ADD, (Object)path));
                        }
                        FileUtils.sortPaths((List)localChange.getModifyPaths());
                        for (String path : localChange.getModifyPaths()) {
                            modifications.add(new Pair((Object)Action.MODIFY, (Object)path));
                        }
                        return modifications;
                    }
                }){

                    protected void populateItem(ListItem item) {
                        final Pair modification = (Pair)item.getModelObject();
                        User requester = Context.getBuild().getRequester();
                        if (requester != null) {
                            item.add(new Component[]{new Label("user", requester.getName())});
                        } else {
                            item.add(new Component[]{new Label("user", "unknown"){

                                protected void onComponentTag(ComponentTag tag) {
                                    super.onComponentTag(tag);
                                    tag.put("class", (CharSequence)"special");
                                }
                            }});
                        }
                        item.add(new Component[]{new Label("action", ((Action)((Object)modification.getFirst())).name())});
                        Link link = new Link("pathLink"){

                            public void onClick() {
                                if (!viewSourceAllowed) {
                                    throw new AccessDeniedException();
                                }
                                if (modification.getFirst() == Action.ADD) {
                                    this.setResponsePage((Page)new SourceViewPage((String)modification.getSecond(), FilenameUtils.getExtension((String)((String)modification.getSecond())), FileUtils.readFileAsLines((File)localChange.getStoredFile(localChangeStoreDir, (String)modification.getSecond())).toArray(new String[0])));
                                } else {
                                    File modifiedFile = new File(localChangeStoreDir, (String)modification.getSecond());
                                    File prevFile = new File(modifiedFile.getAbsolutePath() + ".qbprev");
                                    List originalFileContent = prevFile.exists() ? FileUtils.readFileAsLines((File)prevFile) : repository.getSourceViewSupport().readSourceByRevision((String)modification.getSecond(), repository.getRevision());
                                    if (originalFileContent == null) {
                                        this.setResponsePage((Page)new ErrorMessagePage("Failed to View Source", "Object '" + (String)modification.getSecond() + "@" + repository.getRevision() + "' is not a text file"));
                                    } else {
                                        String[] modifiedSourceLines = FileUtils.readFileAsLines((File)modifiedFile).toArray(new String[0]);
                                        String[] originalSourceLines = originalFileContent.toArray(new String[0]);
                                        this.setResponsePage((Page)new SourceDiffPage((String)modification.getSecond(), FilenameUtils.getExtension((String)((String)modification.getSecond())), modifiedSourceLines, originalSourceLines));
                                    }
                                }
                            }

                            protected void onConfigure() {
                                super.onConfigure();
                                if (!viewSourceAllowed) {
                                    this.setEnabled(false);
                                } else if (modification.getFirst() == Action.DELETE) {
                                    this.setEnabled(false);
                                } else if (modification.getFirst() == Action.MODIFY) {
                                    this.setEnabled(true);
                                } else if (localChange.getStoredFile(localChangeStoreDir, (String)modification.getSecond()).isFile()) {
                                    this.setEnabled(true);
                                } else {
                                    this.setEnabled(false);
                                }
                            }
                        };
                        link.setPopupSettings(new PopupSettings("popup", 12));
                        link.add(new Component[]{new Label("path", (String)modification.getSecond())});
                        item.add(new Component[]{link});
                    }
                }});
            }
        }});
    }

    private static enum Action {
        ADD,
        DELETE,
        MODIFY;

    }
}

